/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;

public class AbstractOAuth2ResourceOwnerAuthenticationToken
extends OAuth2AuthorizationGrantAuthenticationToken {
    private final Set<String> scopes;

    public AbstractOAuth2ResourceOwnerAuthenticationToken(AuthorizationGrantType authorizationGrantType, Authentication clientPrincipal, @Nullable Map<String, Object> additionalParameters, @Nullable Set<String> scopes) {
        super(authorizationGrantType, clientPrincipal, additionalParameters);
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOAuth2ResourceOwnerAuthenticationToken)) {
            return false;
        }
        AbstractOAuth2ResourceOwnerAuthenticationToken other = (AbstractOAuth2ResourceOwnerAuthenticationToken)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$scopes = this.getScopes();
        Set<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractOAuth2ResourceOwnerAuthenticationToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractOAuth2ResourceOwnerAuthenticationToken(super=" + super.toString() + ", scopes=" + this.getScopes() + ")";
    }
}

