/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.authentication;

import java.util.Map;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.AbstractOAuth2ResourceOwnerAuthenticationProvider;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2ResourceOwnerPasswordAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;

public class OAuth2ResourceOwnerPasswordAuthenticationProvider
extends AbstractOAuth2ResourceOwnerAuthenticationProvider<OAuth2ResourceOwnerPasswordAuthenticationToken> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ResourceOwnerPasswordAuthenticationProvider.class);
    private final DaoAuthenticationProvider daoAuthenticationProvider;

    public OAuth2ResourceOwnerPasswordAuthenticationProvider(OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator, UserDetailsService userDetailsService) {
        super(authorizationService, tokenGenerator);
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(userDetailsService);
        this.daoAuthenticationProvider = provider;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.daoAuthenticationProvider.setPasswordEncoder(passwordEncoder);
    }

    public boolean supports(Class<?> authentication) {
        boolean supports = OAuth2ResourceOwnerPasswordAuthenticationToken.class.isAssignableFrom(authentication);
        log.debug("supports authentication={}} returning {}", authentication, (Object)supports);
        return supports;
    }

    @Override
    protected Authentication getAuthenticatedAuthentication(OAuth2ResourceOwnerPasswordAuthenticationToken resourceOwnerPasswordAuthentication) {
        Map additionalParameters = resourceOwnerPasswordAuthentication.getAdditionalParameters();
        String username = (String)additionalParameters.get("username");
        String password = (String)additionalParameters.get("password");
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        log.debug("got usernamePasswordAuthenticationToken={}", (Object)usernamePasswordAuthenticationToken);
        return this.daoAuthenticationProvider.authenticate((Authentication)usernamePasswordAuthenticationToken);
    }
}

