/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.authentication;

import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2TokenRevocationAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2TokenRevocationAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2TokenRevocationAuthenticationProvider.class);
    private final OAuth2AuthorizationService authorizationService;

    public OAuth2TokenRevocationAuthenticationProvider(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2TokenRevocationAuthenticationToken tokenRevocationAuthentication = (OAuth2TokenRevocationAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)tokenRevocationAuthentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        OAuth2Authorization authorization = this.authorizationService.findByToken(tokenRevocationAuthentication.getToken(), null);
        if (authorization == null) {
            if (log.isTraceEnabled()) {
                log.trace("Did not authenticate token revocation request since token was not found");
            }
            return tokenRevocationAuthentication;
        }
        if (!registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        OAuth2Authorization.Token token = authorization.getToken(tokenRevocationAuthentication.getToken());
        authorization = OAuth2AuthenticationProviderUtils.invalidate(authorization, token.getToken());
        this.authorizationService.save(authorization);
        if (log.isTraceEnabled()) {
            log.trace("Saved authorization with revoked token");
            log.trace("Authenticated token revocation request");
        }
        return new OAuth2TokenRevocationAuthenticationToken(authorization, token.getToken(), (Authentication)clientPrincipal);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2TokenRevocationAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

