/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.authentication;

import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;

public class OAuth2TokenRevocationAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    private final OAuth2Authorization authorization;
    private final String token;
    private final Authentication clientPrincipal;
    private final String tokenTypeHint;

    public OAuth2TokenRevocationAuthenticationToken(String token, Authentication clientPrincipal, @Nullable String tokenTypeHint) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.token = token;
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = tokenTypeHint;
        this.authorization = null;
    }

    public OAuth2TokenRevocationAuthenticationToken(OAuth2Authorization authorization, OAuth2Token revokedToken, Authentication clientPrincipal) {
        super(Collections.emptyList());
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        Assert.notNull((Object)revokedToken, (String)"revokedToken cannot be null");
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.authorization = authorization;
        this.token = revokedToken.getTokenValue();
        this.clientPrincipal = clientPrincipal;
        this.tokenTypeHint = null;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.clientPrincipal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getTokenTypeHint() {
        return this.tokenTypeHint;
    }

    public OAuth2Authorization getAuthorization() {
        return this.authorization;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2TokenRevocationAuthenticationToken)) {
            return false;
        }
        OAuth2TokenRevocationAuthenticationToken other = (OAuth2TokenRevocationAuthenticationToken)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Authorization this$authorization = this.getAuthorization();
        OAuth2Authorization other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Authentication this$clientPrincipal = this.clientPrincipal;
        Authentication other$clientPrincipal = other.clientPrincipal;
        if (this$clientPrincipal == null ? other$clientPrincipal != null : !this$clientPrincipal.equals(other$clientPrincipal)) {
            return false;
        }
        String this$tokenTypeHint = this.getTokenTypeHint();
        String other$tokenTypeHint = other.getTokenTypeHint();
        return !(this$tokenTypeHint == null ? other$tokenTypeHint != null : !this$tokenTypeHint.equals(other$tokenTypeHint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2TokenRevocationAuthenticationToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OAuth2Authorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Authentication $clientPrincipal = this.clientPrincipal;
        result = result * 59 + ($clientPrincipal == null ? 43 : $clientPrincipal.hashCode());
        String $tokenTypeHint = this.getTokenTypeHint();
        result = result * 59 + ($tokenTypeHint == null ? 43 : $tokenTypeHint.hashCode());
        return result;
    }

    public String toString() {
        return "OAuth2TokenRevocationAuthenticationToken(super=" + super.toString() + ", authorization=" + this.getAuthorization() + ", token=" + this.getToken() + ", clientPrincipal=" + this.clientPrincipal + ", tokenTypeHint=" + this.getTokenTypeHint() + ")";
    }
}

