/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hccake.ballcat.common.security.authentication.OAuth2UserAuthenticationToken;
import com.hccake.ballcat.common.security.jackson2.LongMixin;
import com.hccake.ballcat.common.security.jackson2.OAuth2UserAuthenticationTokenMixin;
import com.hccake.ballcat.common.security.jackson2.UserMixin;
import com.hccake.ballcat.common.security.userdetails.User;
import com.hccake.ballcat.common.security.util.PasswordUtils;
import java.util.List;
import org.ballcat.springsecurity.oauth2.server.authorization.OAuth2AuthorizationObjectMapperCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.autoconfigure.OAuth2AuthorizationServerConfigurerCustomizerConfiguration;
import org.ballcat.springsecurity.oauth2.server.authorization.autoconfigure.OAuth2AuthorizationServerExtensionConfigurerConfiguration;
import org.ballcat.springsecurity.oauth2.server.authorization.config.BallcatOAuth2AuthorizationServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.authorization.config.OAuth2AuthorizationServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2AuthorizationServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2AuthorizationServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.properties.OAuth2AuthorizationServerProperties;
import org.ballcat.springsecurity.oauth2.server.authorization.token.BallcatOAuth2TokenCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2TokenRevocationResponseHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.JdbcRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.web.SecurityFilterChain;

@Import(value={OAuth2AuthorizationServerConfigurerCustomizerConfiguration.class, OAuth2AuthorizationServerExtensionConfigurerConfiguration.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OAuth2AuthorizationServerProperties.class})
public class OAuth2AuthorizationServerAutoConfiguration {
    public static final String OAUTH2_AUTHORIZATION_SERVER_SECURITY_FILTER_CHAIN_BEAN_NAME = "oauth2AuthorizationServerSecurityFilterChain";

    @Bean
    @ConditionalOnMissingBean(name={"oauth2AuthorizationServerSecurityFilterChain"}, value={OAuth2AuthorizationServerSecurityFilterChainBuilder.class})
    public OAuth2AuthorizationServerSecurityFilterChainBuilder oAuth2AuthorizationServerSecurityFilterChainBuilder(List<OAuth2AuthorizationServerConfigurerCustomizer> oAuth2AuthorizationServerConfigurerCustomizers, List<OAuth2AuthorizationServerExtensionConfigurer<?, HttpSecurity>> oAuth2AuthorizationServerExtensionConfigurers) {
        return new BallcatOAuth2AuthorizationServerSecurityFilterChainBuilder(oAuth2AuthorizationServerConfigurerCustomizers, oAuth2AuthorizationServerExtensionConfigurers);
    }

    @Bean(name={"oauth2AuthorizationServerSecurityFilterChain"})
    @Order(value=1)
    @ConditionalOnMissingBean(name={"oauth2AuthorizationServerSecurityFilterChain"})
    public SecurityFilterChain oauth2AuthorizationServerSecurityFilterChain(OAuth2AuthorizationServerSecurityFilterChainBuilder builder, HttpSecurity httpSecurity) throws Exception {
        return builder.build(httpSecurity);
    }

    @Bean
    @ConditionalOnMissingBean
    public RegisteredClientRepository registeredClientRepository(JdbcTemplate jdbcTemplate) {
        return new JdbcRegisteredClientRepository((JdbcOperations)jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizationService authorizationService(JdbcTemplate jdbcTemplate, RegisteredClientRepository registeredClientRepository, ObjectProvider<OAuth2AuthorizationObjectMapperCustomizer> objectMapperCustomizerObjectProvider) {
        JdbcOAuth2AuthorizationService oAuth2AuthorizationService = new JdbcOAuth2AuthorizationService((JdbcOperations)jdbcTemplate, registeredClientRepository);
        JdbcOAuth2AuthorizationService.OAuth2AuthorizationRowMapper rowMapper = new JdbcOAuth2AuthorizationService.OAuth2AuthorizationRowMapper(registeredClientRepository);
        ObjectMapper objectMapper = new ObjectMapper();
        ClassLoader classLoader = JdbcOAuth2AuthorizationService.class.getClassLoader();
        List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
        objectMapper.registerModules((Iterable)securityModules);
        objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        objectMapper.addMixIn(Long.class, LongMixin.class);
        objectMapper.addMixIn(User.class, UserMixin.class);
        objectMapper.addMixIn(OAuth2UserAuthenticationToken.class, OAuth2UserAuthenticationTokenMixin.class);
        objectMapperCustomizerObjectProvider.ifAvailable(customizer -> customizer.customize(objectMapper));
        rowMapper.setObjectMapper(objectMapper);
        oAuth2AuthorizationService.setAuthorizationRowMapper((RowMapper)rowMapper);
        return oAuth2AuthorizationService;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizationConsentService authorizationConsentService(JdbcTemplate jdbcTemplate, RegisteredClientRepository registeredClientRepository) {
        return new JdbcOAuth2AuthorizationConsentService((JdbcOperations)jdbcTemplate, registeredClientRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorizationServerSettings authorizationServerSettings() {
        return AuthorizationServerSettings.builder().build();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2TokenRevocationResponseHandler oAuth2TokenRevocationResponseHandler(ApplicationEventPublisher publisher) {
        return new OAuth2TokenRevocationResponseHandler(publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return PasswordUtils.createDelegatingPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2TokenCustomizer.class})
    public OAuth2TokenCustomizer<OAuth2TokenClaimsContext> oAuth2TokenCustomizer() {
        return new BallcatOAuth2TokenCustomizer();
    }
}

