/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.autoconfigure;

import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.FormLoginConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2ResourceOwnerPasswordConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2TokenResponseEnhanceConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2TokenRevocationEndpointConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.properties.OAuth2AuthorizationServerProperties;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2TokenResponseEnhancer;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2TokenRevocationResponseHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;

@Configuration(proxyBeanMethods=false)
public class OAuth2AuthorizationServerConfigurerCustomizerConfiguration {
    private final OAuth2AuthorizationServerProperties oAuth2AuthorizationServerProperties;
    private final OAuth2AuthorizationService oAuth2AuthorizationService;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="ballcat.security.oauth2.authorizationserver", name={"form-login-enabled"}, havingValue="true")
    public FormLoginConfigurerCustomizer formLoginConfigurerCustomizer(UserDetailsService userDetailsService) {
        return new FormLoginConfigurerCustomizer(this.oAuth2AuthorizationServerProperties, userDetailsService);
    }

    @Bean
    public OAuth2ResourceOwnerPasswordConfigurerCustomizer oAuth2ResourceOwnerPasswordConfigurerCustomizer(ApplicationContext applicationContext) {
        return new OAuth2ResourceOwnerPasswordConfigurerCustomizer(applicationContext);
    }

    @Bean
    @ConditionalOnBean(value={OAuth2TokenResponseEnhancer.class})
    public OAuth2TokenResponseEnhanceConfigurerCustomizer oAuth2TokenResponseEnhanceConfigurerCustomizer(OAuth2TokenResponseEnhancer oauth2TokenResponseEnhancer) {
        return new OAuth2TokenResponseEnhanceConfigurerCustomizer(oauth2TokenResponseEnhancer);
    }

    @Bean
    @ConditionalOnBean(value={OAuth2TokenRevocationResponseHandler.class})
    public OAuth2TokenRevocationEndpointConfigurerCustomizer oAuth2TokenRevocationEndpointConfigurerCustomizer(OAuth2TokenRevocationResponseHandler oAuth2TokenRevocationResponseHandler) {
        return new OAuth2TokenRevocationEndpointConfigurerCustomizer(this.oAuth2AuthorizationService, oAuth2TokenRevocationResponseHandler);
    }

    public OAuth2AuthorizationServerConfigurerCustomizerConfiguration(OAuth2AuthorizationServerProperties oAuth2AuthorizationServerProperties, OAuth2AuthorizationService oAuth2AuthorizationService) {
        this.oAuth2AuthorizationServerProperties = oAuth2AuthorizationServerProperties;
        this.oAuth2AuthorizationService = oAuth2AuthorizationService;
    }
}

