/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.autoconfigure;

import org.ballcat.security.captcha.CaptchaValidator;
import org.ballcat.security.properties.SecurityProperties;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2LoginCaptchaConfigurer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2LoginPasswordDecoderConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class OAuth2AuthorizationServerExtensionConfigurerConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="ballcat.security.oauth2.authorizationserver", name={"login-captcha-enabled"}, havingValue="true")
    public OAuth2LoginCaptchaConfigurer oAuth2LoginCaptchaConfigurer(CaptchaValidator captchaValidator) {
        return new OAuth2LoginCaptchaConfigurer(captchaValidator);
    }

    @Bean
    @ConditionalOnProperty(prefix="ballcat.security", name={"password-secret-key"})
    public OAuth2LoginPasswordDecoderConfigurer oAuth2LoginPasswordDecoderConfigurer(SecurityProperties securityProperties) {
        return new OAuth2LoginPasswordDecoderConfigurer(securityProperties.getPasswordSecretKey());
    }
}

