/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ballcat.springsecurity.oauth2.server.authorization.config.OAuth2AuthorizationServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2AuthorizationServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2AuthorizationServerConfigurerCustomizer;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public class BallcatOAuth2AuthorizationServerSecurityFilterChainBuilder
implements OAuth2AuthorizationServerSecurityFilterChainBuilder {
    private final List<OAuth2AuthorizationServerConfigurerCustomizer> oAuth2AuthorizationServerConfigurerCustomizerList;
    private final List<OAuth2AuthorizationServerExtensionConfigurer<?, HttpSecurity>> oAuth2AuthorizationServerExtensionConfigurers;

    @Override
    public SecurityFilterChain build(HttpSecurity http) throws Exception {
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        for (OAuth2AuthorizationServerConfigurerCustomizer customizer : this.oAuth2AuthorizationServerConfigurerCustomizerList) {
            customizer.customize(authorizationServerConfigurer, http);
        }
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        ((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().requestMatchers(new RequestMatcher[]{endpointsMatcher})).and().authorizeRequests(authorizeRequests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.anyRequest()).authenticated()).csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher})).apply((SecurityConfigurerAdapter)authorizationServerConfigurer);
        for (OAuth2AuthorizationServerExtensionConfigurer<?, HttpSecurity> configurer : this.oAuth2AuthorizationServerExtensionConfigurers) {
            http.apply(configurer);
        }
        return (SecurityFilterChain)http.build();
    }

    protected final RequestMatcher getAuthenticationEntryPointMatcher(HttpSecurity http) {
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher mediaMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        mediaMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        return new AndRequestMatcher(Arrays.asList(notXRequestedWith, mediaMatcher));
    }

    public BallcatOAuth2AuthorizationServerSecurityFilterChainBuilder(List<OAuth2AuthorizationServerConfigurerCustomizer> oAuth2AuthorizationServerConfigurerCustomizerList, List<OAuth2AuthorizationServerExtensionConfigurer<?, HttpSecurity>> oAuth2AuthorizationServerExtensionConfigurers) {
        this.oAuth2AuthorizationServerConfigurerCustomizerList = oAuth2AuthorizationServerConfigurerCustomizerList;
        this.oAuth2AuthorizationServerExtensionConfigurers = oAuth2AuthorizationServerExtensionConfigurers;
    }
}

