/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config.configurer;

import cn.hutool.core.lang.Assert;
import javax.servlet.Filter;
import org.ballcat.security.captcha.CaptchaValidator;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2AuthorizationServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.authorization.web.filter.LoginCaptchaFilter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2ClientAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=90)
public class OAuth2LoginCaptchaConfigurer
extends OAuth2AuthorizationServerExtensionConfigurer<OAuth2LoginCaptchaConfigurer, HttpSecurity> {
    private final CaptchaValidator captchaValidator;

    public OAuth2LoginCaptchaConfigurer(CaptchaValidator captchaValidator) {
        Assert.notNull((Object)captchaValidator, (String)"captchaValidator can not be null", (Object[])new Object[0]);
        this.captchaValidator = captchaValidator;
    }

    public void configure(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = (AuthorizationServerSettings)httpSecurity.getSharedObject(AuthorizationServerSettings.class);
        AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(authorizationServerSettings.getTokenEndpoint(), HttpMethod.POST.name());
        httpSecurity.addFilterAfter((Filter)new LoginCaptchaFilter((RequestMatcher)requestMatcher, this.captchaValidator), OAuth2ClientAuthenticationFilter.class);
    }
}

