/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config.configurer;

import cn.hutool.core.lang.Assert;
import javax.servlet.Filter;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2AuthorizationServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.authorization.web.filter.LoginPasswordDecoderFilter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2ClientAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=100)
public class OAuth2LoginPasswordDecoderConfigurer
extends OAuth2AuthorizationServerExtensionConfigurer<OAuth2LoginPasswordDecoderConfigurer, HttpSecurity> {
    private final String passwordSecretKey;

    public OAuth2LoginPasswordDecoderConfigurer(String passwordSecretKey) {
        Assert.notEmpty((CharSequence)passwordSecretKey, (String)"passwordSecretKey can not be null", (Object[])new Object[0]);
        this.passwordSecretKey = passwordSecretKey;
    }

    public void configure(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = (AuthorizationServerSettings)httpSecurity.getSharedObject(AuthorizationServerSettings.class);
        AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher(authorizationServerSettings.getTokenEndpoint(), HttpMethod.POST.name());
        httpSecurity.addFilterAfter((Filter)new LoginPasswordDecoderFilter((RequestMatcher)requestMatcher, this.passwordSecretKey), OAuth2ClientAuthenticationFilter.class);
    }
}

