/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config.customizer;

import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2AuthorizationServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.properties.OAuth2AuthorizationServerProperties;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;

public class FormLoginConfigurerCustomizer
implements OAuth2AuthorizationServerConfigurerCustomizer {
    private final OAuth2AuthorizationServerProperties oAuth2AuthorizationServerProperties;
    private final UserDetailsService userDetailsService;

    @Override
    public void customize(OAuth2AuthorizationServerConfigurer oAuth2AuthorizationServerConfigurer, HttpSecurity httpSecurity) throws Exception {
        if (this.oAuth2AuthorizationServerProperties.isLoginPageEnabled()) {
            String loginPage = this.oAuth2AuthorizationServerProperties.getLoginPage();
            HttpSecurity.RequestMatcherConfigurer requestMatcherConfigurer = httpSecurity.requestMatchers();
            if (loginPage == null) {
                requestMatcherConfigurer.antMatchers(new String[]{"/login"});
                httpSecurity.formLogin();
            } else {
                requestMatcherConfigurer.antMatchers(new String[]{loginPage});
                httpSecurity.formLogin(form -> {
                    FormLoginConfigurer cfr_ignored_0 = (FormLoginConfigurer)form.loginPage(loginPage).permitAll();
                });
            }
            httpSecurity.userDetailsService(this.userDetailsService);
        }
    }

    public FormLoginConfigurerCustomizer(OAuth2AuthorizationServerProperties oAuth2AuthorizationServerProperties, UserDetailsService userDetailsService) {
        this.oAuth2AuthorizationServerProperties = oAuth2AuthorizationServerProperties;
        this.userDetailsService = userDetailsService;
    }
}

