/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config.customizer;

import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2ConfigurerUtils;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2AuthorizationServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.properties.OAuth2AuthorizationServerProperties;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2LoginUrlAuthenticationEntryPoint;
import org.ballcat.springsecurity.oauth2.server.authorization.web.context.OAuth2SecurityContextRepository;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class OAuth2AuthorizationEndpointConfigurerCustomizer
implements OAuth2AuthorizationServerConfigurerCustomizer {
    private final OAuth2AuthorizationServerProperties properties;
    private final OAuth2SecurityContextRepository oAuth2SecurityContextRepository;

    public OAuth2AuthorizationEndpointConfigurerCustomizer(OAuth2AuthorizationServerProperties properties, OAuth2SecurityContextRepository oAuth2SecurityContextRepository) {
        this.properties = properties;
        this.oAuth2SecurityContextRepository = oAuth2SecurityContextRepository;
    }

    @Override
    public void customize(OAuth2AuthorizationServerConfigurer oAuth2AuthorizationServerConfigurer, HttpSecurity httpSecurity) throws Exception {
        String consentPage;
        if (this.properties.isStateless()) {
            httpSecurity.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
            httpSecurity.securityContext(security -> security.securityContextRepository((SecurityContextRepository)this.oAuth2SecurityContextRepository));
        }
        String loginPage = this.properties.getLoginPage();
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)httpSecurity.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new OAuth2LoginUrlAuthenticationEntryPoint(loginPage), (RequestMatcher)new AntPathRequestMatcher(authorizationServerSettings.getAuthorizationEndpoint(), HttpMethod.GET.name()));
        }
        if ((consentPage = this.properties.getConsentPage()) != null) {
            oAuth2AuthorizationServerConfigurer.authorizationEndpoint(configurer -> configurer.consentPage(consentPage));
        }
    }
}

