/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.config.customizer;

import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2ResourceOwnerPasswordAuthenticationProvider;
import org.ballcat.springsecurity.oauth2.server.authorization.config.configurer.OAuth2ConfigurerUtils;
import org.ballcat.springsecurity.oauth2.server.authorization.config.customizer.OAuth2AuthorizationServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2ResourceOwnerPasswordAuthenticationConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.authentication.AuthenticationConverter;

public class OAuth2ResourceOwnerPasswordConfigurerCustomizer
implements OAuth2AuthorizationServerConfigurerCustomizer {
    private final ApplicationContext context;

    @Override
    public void customize(OAuth2AuthorizationServerConfigurer oAuth2AuthorizationServerConfigurer, HttpSecurity httpSecurity) {
        oAuth2AuthorizationServerConfigurer.tokenEndpoint(tokenEndpoint -> {
            UserDetailsService userDetailsService = this.getBeanOrNull(UserDetailsService.class);
            OAuth2AuthorizationService authorizationService = this.getBeanOrNull(OAuth2AuthorizationService.class);
            OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator = OAuth2ConfigurerUtils.getTokenGenerator(httpSecurity);
            PasswordEncoder passwordEncoder = this.getBeanOrNull(PasswordEncoder.class);
            OAuth2ResourceOwnerPasswordAuthenticationProvider authenticationProvider = new OAuth2ResourceOwnerPasswordAuthenticationProvider(authorizationService, tokenGenerator, userDetailsService);
            if (passwordEncoder != null) {
                authenticationProvider.setPasswordEncoder(passwordEncoder);
            }
            tokenEndpoint.authenticationProvider((AuthenticationProvider)authenticationProvider);
            tokenEndpoint.accessTokenRequestConverter((AuthenticationConverter)new OAuth2ResourceOwnerPasswordAuthenticationConverter());
        });
    }

    private <T> T getBeanOrNull(Class<T> type) {
        String[] beanNames = this.context.getBeanNamesForType(type);
        if (beanNames.length != 1) {
            return null;
        }
        return (T)this.context.getBean(beanNames[0], type);
    }

    public OAuth2ResourceOwnerPasswordConfigurerCustomizer(ApplicationContext context) {
        this.context = context;
    }
}

