/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.token;

import com.hccake.ballcat.common.security.userdetails.User;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public class BallcatOAuth2TokenCustomizer
implements OAuth2TokenCustomizer<OAuth2TokenClaimsContext> {
    public void customize(OAuth2TokenClaimsContext context) {
        OAuth2TokenClaimsSet.Builder claims = context.getClaims();
        Authentication authentication = context.getPrincipal();
        if (authentication instanceof OAuth2ClientAuthenticationToken) {
            claims.claim("is_client", (Object)true);
            return;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof User) {
            User user = (User)principal;
            Map attributes = user.getAttributes();
            claims.claim("attributes", (Object)attributes);
            HashMap<String, Object> userInfoMap = BallcatOAuth2TokenCustomizer.getUserInfoMap(user);
            claims.claim("info", userInfoMap);
            claims.claim("is_client", (Object)false);
        }
    }

    private static HashMap<String, Object> getUserInfoMap(User user) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>(6);
        userInfo.put("userId", user.getUserId());
        userInfo.put("type", user.getType());
        userInfo.put("organizationId", user.getOrganizationId());
        userInfo.put("username", user.getUsername());
        userInfo.put("nickname", user.getNickname());
        userInfo.put("avatar", user.getAvatar());
        userInfo.put("email", user.getEmail());
        userInfo.put("gender", user.getGender());
        userInfo.put("phoneNumber", user.getPhoneNumber());
        userInfo.put("status", user.getStatus());
        return userInfo;
    }
}

