/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.Assert;

public class CookieBearerTokenResolver
implements BearerTokenResolver {
    private String cookieName = OAuth2TokenType.ACCESS_TOKEN.getValue();

    public CookieBearerTokenResolver() {
    }

    public CookieBearerTokenResolver(String cookieName) {
        Assert.hasText((String)cookieName, (String)"cookie name cannot be empty");
        this.cookieName = cookieName;
    }

    public String resolve(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

