/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.web.authentication;

import cn.hutool.core.net.url.UrlBuilder;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class OAuth2LoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    public OAuth2LoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    protected String buildRedirectUrlToLoginPage(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        String loginForm = super.buildRedirectUrlToLoginPage(request, response, authException);
        return OAuth2LoginUrlAuthenticationEntryPoint.addReturnToParameter(request, loginForm);
    }

    private static String addReturnToParameter(HttpServletRequest request, String loginForm) {
        return UrlBuilder.of((String)loginForm).addQuery("return_to", (Object)OAuth2LoginUrlAuthenticationEntryPoint.getFullUrl(request)).build();
    }

    private static String getFullUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }

    protected String buildHttpsRedirectUrlForRequest(HttpServletRequest request) throws IOException, ServletException {
        String loginForm = super.buildHttpsRedirectUrlForRequest(request);
        return OAuth2LoginUrlAuthenticationEntryPoint.addReturnToParameter(request, loginForm);
    }
}

