/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.web.authentication;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2ResourceOwnerPasswordAuthenticationToken;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2ResourceOwnerPasswordAuthenticationConverter
implements AuthenticationConverter {
    public Authentication convert(HttpServletRequest request) {
        Authentication clientPrincipal;
        String password;
        String username;
        String grantType = request.getParameter("grant_type");
        if (!AuthorizationGrantType.PASSWORD.getValue().equals(grantType)) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        HashSet<String> scopes = null;
        String scope = (String)parameters.getFirst((Object)"scope");
        if (StringUtils.hasText((String)scope) && ((List)parameters.get((Object)"scope")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "scope", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if (StringUtils.hasText((String)scope)) {
            scopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        if (!StringUtils.hasText((String)(username = (String)parameters.getFirst((Object)"username"))) || ((List)parameters.get((Object)"username")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "username", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if (!StringUtils.hasText((String)(password = (String)parameters.getFirst((Object)"password"))) || ((List)parameters.get((Object)"password")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "password", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if ((clientPrincipal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            OAuth2EndpointUtils.throwError("invalid_request", "invalid_client", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        Map<String, Object> additionalParameters = parameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("grant_type") && !((String)e.getKey()).equals("scope")).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
        return new OAuth2ResourceOwnerPasswordAuthenticationToken(username, clientPrincipal, additionalParameters, scopes);
    }
}

