/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.web.filter;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import com.hccake.ballcat.common.util.JsonUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ballcat.security.captcha.CaptchaValidateResult;
import org.ballcat.security.captcha.CaptchaValidator;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoginCaptchaFilter
extends OncePerRequestFilter {
    private final RequestMatcher requestMatcher;
    private final CaptchaValidator captchaValidator;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String grantType = request.getParameter("grant_type");
        if (!AuthorizationGrantType.PASSWORD.getValue().equals(grantType)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient(authentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (registeredClient != null && registeredClient.getScopes().contains("skip_captcha")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        CaptchaValidateResult captchaValidateResult = this.captchaValidator.validate(request);
        if (captchaValidateResult.isSuccess()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            R r = R.failed((ResultCode)SystemResultCode.UNAUTHORIZED, (String)CharSequenceUtil.blankToDefault((CharSequence)captchaValidateResult.getMessage(), (String)"Captcha code error"));
            response.getWriter().write(JsonUtils.toJson((Object)r));
        }
    }

    public LoginCaptchaFilter(RequestMatcher requestMatcher, CaptchaValidator captchaValidator) {
        this.requestMatcher = requestMatcher;
        this.captchaValidator = captchaValidator;
    }
}

