/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.authorization.web.filter;

import com.hccake.ballcat.common.core.request.wrapper.ModifyParamMapRequestWrapper;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import com.hccake.ballcat.common.security.util.PasswordUtils;
import com.hccake.ballcat.common.util.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoginPasswordDecoderFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LoginPasswordDecoderFilter.class);
    private final RequestMatcher requestMatcher;
    private final String passwordSecretKey;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.passwordSecretKey == null) {
            log.warn("passwordSecretKey not configured, skip password decoder");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String grantType = request.getParameter("grant_type");
        if (!AuthorizationGrantType.PASSWORD.getValue().equals(grantType)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient(authentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (registeredClient != null && registeredClient.getScopes().contains("skip_password_decode")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(request.getParameterMap());
        String passwordAes = request.getParameter("password");
        try {
            String password = PasswordUtils.decodeAES((String)passwordAes, (String)this.passwordSecretKey);
            parameterMap.put("password", new String[]{password});
        }
        catch (Exception e) {
            log.error("[doFilterInternal] password decode aes error\uff0cpasswordAes: {}\uff0cpasswordSecretKey: {}", new Object[]{passwordAes, this.passwordSecretKey, e});
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            R r = R.failed((ResultCode)SystemResultCode.UNAUTHORIZED, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01");
            response.getWriter().write(JsonUtils.toJson((Object)r));
            return;
        }
        filterChain.doFilter((ServletRequest)new ModifyParamMapRequestWrapper(request, parameterMap), (ServletResponse)response);
    }

    public LoginPasswordDecoderFilter(RequestMatcher requestMatcher, String passwordSecretKey) {
        this.requestMatcher = requestMatcher;
        this.passwordSecretKey = passwordSecretKey;
    }
}

