/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.resource.configurer;

import cn.hutool.core.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.OAuth2ResourceServerConfigurerCustomizer;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.OAuth2ResourceServerExtensionConfigurer;
import org.ballcat.springsecurity.oauth2.server.resource.configurer.Oauth2ResourceServerSecurityFilterChainBuilder;
import org.ballcat.springsecurity.oauth2.server.resource.properties.OAuth2ResourceServerProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;

public class BallcatOauth2ResourceServerSecurityFilterChainBuilder
implements Oauth2ResourceServerSecurityFilterChainBuilder {
    private final OAuth2ResourceServerProperties oAuth2ResourceServerProperties;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final BearerTokenResolver bearerTokenResolver;
    private final ObjectProvider<List<OAuth2ResourceServerConfigurerCustomizer>> configurerCustomizersProvider;
    private final ObjectProvider<List<OAuth2ResourceServerExtensionConfigurer<HttpSecurity>>> extensionConfigurersProvider;

    @Override
    public SecurityFilterChain build(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers((String[])ArrayUtil.toArray(this.oAuth2ResourceServerProperties.getIgnoreUrls(), String.class))).permitAll().anyRequest()).authenticated().and()).csrf().disable()).oauth2ResourceServer().authenticationEntryPoint(this.authenticationEntryPoint).bearerTokenResolver(this.bearerTokenResolver).opaqueToken();
        if (!this.oAuth2ResourceServerProperties.isIframeDeny()) {
            http.headers().frameOptions().disable();
        }
        List configurerCustomizers = (List)this.configurerCustomizersProvider.getIfAvailable(Collections::emptyList);
        for (OAuth2ResourceServerConfigurerCustomizer configurerCustomizer : configurerCustomizers) {
            configurerCustomizer.customize(http);
        }
        List extensionConfigurers = (List)this.extensionConfigurersProvider.getIfAvailable(Collections::emptyList);
        for (OAuth2ResourceServerExtensionConfigurer extensionConfigurer : extensionConfigurers) {
            http.apply((SecurityConfigurerAdapter)extensionConfigurer);
        }
        return (SecurityFilterChain)http.build();
    }

    public BallcatOauth2ResourceServerSecurityFilterChainBuilder(OAuth2ResourceServerProperties oAuth2ResourceServerProperties, AuthenticationEntryPoint authenticationEntryPoint, BearerTokenResolver bearerTokenResolver, ObjectProvider<List<OAuth2ResourceServerConfigurerCustomizer>> configurerCustomizersProvider, ObjectProvider<List<OAuth2ResourceServerExtensionConfigurer<HttpSecurity>>> extensionConfigurersProvider) {
        this.oAuth2ResourceServerProperties = oAuth2ResourceServerProperties;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.bearerTokenResolver = bearerTokenResolver;
        this.configurerCustomizersProvider = configurerCustomizersProvider;
        this.extensionConfigurersProvider = extensionConfigurersProvider;
    }
}

