/*
 * Decompiled with CFR 0.152.
 */
package org.ballcat.springsecurity.oauth2.server.resource.introspection;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.security.userdetails.ClientPrincipal;
import com.hccake.ballcat.common.security.userdetails.User;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class BallcatRemoteOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RestOperations restOperations;
    private Converter<String, RequestEntity<?>> requestEntityConverter;
    private static final List<String> INTROSPECTION_CLAIM_NAMES = Arrays.asList("active", "username", "client_id", "scope", "token_type", "exp", "iat", "nbf", "sub", "aud", "iss", "jti");

    public BallcatRemoteOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)clientId, (String)"clientId cannot be null");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(clientId, clientSecret));
        this.restOperations = restTemplate;
    }

    public BallcatRemoteOpaqueTokenIntrospector(String introspectionUri, RestOperations restOperations) {
        Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        this.restOperations = restOperations;
    }

    private Converter<String, RequestEntity<?>> defaultRequestEntityConverter(URI introspectionUri) {
        return token -> {
            HttpHeaders headers = this.requestHeaders();
            MultiValueMap<String, String> body = this.requestBody((String)token);
            return new RequestEntity(body, (MultiValueMap)headers, HttpMethod.POST, introspectionUri);
        };
    }

    private HttpHeaders requestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    private MultiValueMap<String, String> requestBody(String token) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"token", (Object)token);
        return body;
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        RequestEntity requestEntity = (RequestEntity)this.requestEntityConverter.convert((Object)token);
        if (requestEntity == null) {
            throw new OAuth2IntrospectionException("requestEntityConverter returned a null entity");
        }
        ResponseEntity<Map<String, Object>> responseEntity = this.makeRequest(requestEntity);
        Map<String, Object> claims = this.adaptToNimbusResponse(responseEntity);
        return this.convertClaimsSet(claims);
    }

    public void setRequestEntityConverter(Converter<String, RequestEntity<?>> requestEntityConverter) {
        Assert.notNull(requestEntityConverter, (String)"requestEntityConverter cannot be null");
        this.requestEntityConverter = requestEntityConverter;
    }

    private ResponseEntity<Map<String, Object>> makeRequest(RequestEntity<?> requestEntity) {
        try {
            return this.restOperations.exchange(requestEntity, STRING_OBJECT_MAP);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Map<String, Object> adaptToNimbusResponse(ResponseEntity<Map<String, Object>> responseEntity) {
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new OAuth2IntrospectionException("Introspection endpoint responded with " + responseEntity.getStatusCode());
        }
        Map claims = (Map)responseEntity.getBody();
        if (claims == null) {
            return Collections.emptyMap();
        }
        boolean active = (Boolean)claims.compute("active", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            return false;
        });
        if (!active) {
            this.logger.trace("Did not validate token since it is inactive");
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
        return claims;
    }

    private OAuth2AuthenticatedPrincipal convertClaimsSet(Map<String, Object> claims) {
        claims.computeIfPresent("aud", (k, v) -> {
            if (v instanceof String) {
                return Collections.singletonList(v);
            }
            return v;
        });
        claims.computeIfPresent("client_id", (k, v) -> v.toString());
        claims.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        claims.computeIfPresent("iss", (k, v) -> v.toString());
        claims.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        claims.computeIfPresent("scope", (k, v) -> {
            if (v instanceof String) {
                List<String> scopes = Arrays.asList(((String)v).split(" "));
                for (String scope : scopes) {
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(AUTHORITY_PREFIX + scope));
                }
                return scopes;
            }
            return v;
        });
        boolean isClient = (Boolean)claims.compute("is_client", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            this.logger.warn("\u81ea\u5b9a\u7aef\u70b9\u8fd4\u56de\u7684 {} \u5c5e\u6027\u89e3\u6790\u5f02\u5e38, \u503c\u4e3a: {},", (Object)"is_client", v);
            return false;
        });
        return isClient ? this.buildClient(claims, authorities) : this.buildUser(claims);
    }

    private ClientPrincipal buildClient(Map<String, Object> claims, Collection<GrantedAuthority> authorities) {
        String clientId = (String)claims.get("client_id");
        Collection scopes = claims.getOrDefault("scope", new ArrayList());
        ClientPrincipal clientPrincipal = new ClientPrincipal(clientId, claims, authorities);
        clientPrincipal.setScope(scopes);
        return clientPrincipal;
    }

    private User buildUser(Map<String, Object> claims) {
        Map attributesMap;
        Object organizationIdObject;
        User.UserBuilder builder = User.builder();
        LinkedHashMap<String, Object> info = claims.getOrDefault("info", new LinkedHashMap());
        Object userIdObject = info.get("userId");
        if (userIdObject != null) {
            builder.userId(Long.valueOf(Long.parseLong(userIdObject.toString())));
        }
        if ((organizationIdObject = info.get("organizationId")) != null) {
            builder.organizationId(Long.valueOf(Long.parseLong(organizationIdObject.toString())));
        }
        builder.username(BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "username", "")).nickname(BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "nickname", "")).avatar(BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "avatar", "")).email(BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "email", "")).phoneNumber(BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "phoneNumber", "")).gender((Integer)BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "gender", null)).type((Integer)BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "type", null)).status((Integer)BallcatRemoteOpaqueTokenIntrospector.getOrDefault(info, "status", null));
        Collection authorities = null;
        List authoritiesJsonArray = claims.getOrDefault("authorities", new ArrayList());
        if (authoritiesJsonArray != null) {
            authorities = AuthorityUtils.createAuthorityList((String[])authoritiesJsonArray.toArray(new String[0]));
            builder.authorities(authorities);
        }
        if (!CollectionUtils.isEmpty((Map)(attributesMap = (Map)claims.getOrDefault("attributes", new HashMap(0))))) {
            claims.putAll(attributesMap);
            if (CollUtil.isEmpty((Collection)authorities)) {
                Collection roleCodes = attributesMap.getOrDefault("roleCodes", Collections.emptySet());
                Collection permissions = attributesMap.getOrDefault("permissions", Collections.emptySet());
                authorities = Stream.of(roleCodes, permissions).flatMap(Collection::stream).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
                builder.authorities(authorities);
            }
        }
        for (String claimName : INTROSPECTION_CLAIM_NAMES) {
            attributesMap.put(claimName, claims.get(claimName));
        }
        return builder.attributes(attributesMap).build();
    }

    private static <T> T getOrDefault(LinkedHashMap<String, Object> info, String key, T defaultValue) {
        Object value = info.get(key);
        return (T)(value == null ? defaultValue : value);
    }
}

