/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.authentication;

import com.hccake.ballcat.common.security.userdetails.User;
import com.hccake.ballcat.system.model.vo.SysUserInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2TokenResponseEnhancer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;

public class BallcatOAuth2TokenResponseEnhancer
implements OAuth2TokenResponseEnhancer {
    public Map<String, Object> enhance(OAuth2AccessTokenAuthenticationToken accessTokenAuthentication) {
        Object principal = Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::getPrincipal).orElse(null);
        HashMap<String, Object> additionalParameters = accessTokenAuthentication.getAdditionalParameters();
        if (additionalParameters == null) {
            additionalParameters = new HashMap<String, Object>(8);
        }
        if (principal instanceof User) {
            User user = principal;
            SysUserInfo sysUserInfo = this.getSysUserInfo(user);
            additionalParameters.put("info", sysUserInfo);
            HashMap resultAttributes = new HashMap(2);
            Map attributes = user.getAttributes();
            resultAttributes.put("roleCodes", attributes.get("roleCodes"));
            resultAttributes.put("permissions", attributes.get("permissions"));
            additionalParameters.put("attributes", resultAttributes);
        }
        return additionalParameters;
    }

    public SysUserInfo getSysUserInfo(User user) {
        SysUserInfo sysUserInfo = new SysUserInfo();
        sysUserInfo.setUserId(user.getUserId());
        sysUserInfo.setUsername(user.getUsername());
        sysUserInfo.setNickname(user.getNickname());
        sysUserInfo.setAvatar(user.getAvatar());
        sysUserInfo.setOrganizationId(user.getOrganizationId());
        sysUserInfo.setType(user.getType());
        sysUserInfo.setPhoneNumber(user.getPhoneNumber());
        sysUserInfo.setEmail(user.getEmail());
        sysUserInfo.setGender(user.getGender());
        return sysUserInfo;
    }
}

