/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.authentication;

import com.hccake.ballcat.common.security.userdetails.User;
import com.hccake.ballcat.system.authentication.UserInfoCoordinator;
import com.hccake.ballcat.system.model.dto.UserInfoDTO;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.service.SysUserService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.CollectionUtils;

public class SysUserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(SysUserDetailsServiceImpl.class);
    private final SysUserService sysUserService;
    private final UserInfoCoordinator userInfoCoordinator;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        SysUser sysUser = this.sysUserService.getByUsername(username);
        if (sysUser == null) {
            log.error("\u767b\u5f55\uff1a\u7528\u6237\u540d\u9519\u8bef\uff0c\u7528\u6237\u540d\uff1a{}", (Object)username);
            throw new UsernameNotFoundException("username error!");
        }
        UserInfoDTO userInfoDTO = this.sysUserService.findUserInfo(sysUser);
        return this.getUserDetailsByUserInfo(userInfoDTO);
    }

    public UserDetails getUserDetailsByUserInfo(UserInfoDTO userInfoDTO) {
        SysUser sysUser = userInfoDTO.getSysUser();
        Collection roleCodes = userInfoDTO.getRoleCodes();
        Collection permissions = userInfoDTO.getPermissions();
        HashSet dbAuthsSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            dbAuthsSet.addAll(roleCodes);
            dbAuthsSet.addAll(permissions);
        }
        List authorities = AuthorityUtils.createAuthorityList((String[])dbAuthsSet.toArray(new String[0]));
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        attributes.put("roleCodes", roleCodes);
        attributes.put("permissions", permissions);
        this.userInfoCoordinator.coordinateAttribute(userInfoDTO, attributes);
        return User.builder().userId(sysUser.getUserId()).username(sysUser.getUsername()).password(sysUser.getPassword()).nickname(sysUser.getNickname()).avatar(sysUser.getAvatar()).status(sysUser.getStatus()).organizationId(sysUser.getOrganizationId()).email(sysUser.getEmail()).phoneNumber(sysUser.getPhoneNumber()).gender(sysUser.getGender()).type(sysUser.getType()).authorities((Collection)authorities).attributes(attributes).build();
    }

    public SysUserDetailsServiceImpl(SysUserService sysUserService, UserInfoCoordinator userInfoCoordinator) {
        this.sysUserService = sysUserService;
        this.userInfoCoordinator = userInfoCoordinator;
    }
}

