/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.checker;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.system.checker.AdminUserChecker;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.properties.SystemProperties;
import org.springframework.stereotype.Service;

@Service
public class AdminUserCheckerImpl
implements AdminUserChecker {
    private final SystemProperties systemProperties;

    @Override
    public boolean isAdminUser(SysUser user) {
        SystemProperties.Administrator administrator = this.systemProperties.getAdministrator();
        if ((long)administrator.getUserId() == user.getUserId()) {
            return true;
        }
        return CharSequenceUtil.isNotEmpty((CharSequence)administrator.getUsername()) && administrator.getUsername().equals(user.getUsername());
    }

    @Override
    public boolean hasModifyPermission(SysUser targetUser) {
        if (this.isAdminUser(targetUser)) {
            return SecurityUtils.getUser().getUsername().equals(targetUser.getUsername());
        }
        return true;
    }

    public AdminUserCheckerImpl(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }
}

