/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.component;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.crypto.CryptoException;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.security.util.PasswordUtils;
import com.hccake.ballcat.system.properties.SystemProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballcat.security.properties.SecurityProperties;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class PasswordHelper {
    private final SecurityProperties securityProperties;
    private final PasswordEncoder passwordEncoder;
    private final Pattern passwordPattern;

    public PasswordHelper(SecurityProperties securityProperties, SystemProperties systemProperties, PasswordEncoder passwordEncoder) {
        this.securityProperties = securityProperties;
        this.passwordEncoder = passwordEncoder;
        String passwordRule = systemProperties.getPasswordRule();
        this.passwordPattern = CharSequenceUtil.isEmpty((CharSequence)passwordRule) ? null : Pattern.compile(passwordRule);
    }

    public String encode(String rawPassword) {
        return this.passwordEncoder.encode((CharSequence)rawPassword);
    }

    public String decodeAes(String aesPass) {
        try {
            return PasswordUtils.decodeAES((String)aesPass, (String)this.securityProperties.getPasswordSecretKey());
        }
        catch (CryptoException ex) {
            throw new BusinessException(400, "\u5bc6\u7801\u5bc6\u6587\u89e3\u5bc6\u5f02\u5e38\uff01");
        }
    }

    public boolean validateRule(String rawPassword) {
        if (this.passwordPattern == null) {
            return true;
        }
        Matcher matcher = this.passwordPattern.matcher(rawPassword);
        return matcher.matches();
    }
}

