/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.system.converter.SysDictItemConverter;
import com.hccake.ballcat.system.event.DictChangeEvent;
import com.hccake.ballcat.system.model.dto.SysDictItemDTO;
import com.hccake.ballcat.system.model.entity.SysDict;
import com.hccake.ballcat.system.model.entity.SysDictItem;
import com.hccake.ballcat.system.model.qo.SysDictQO;
import com.hccake.ballcat.system.model.vo.DictDataVO;
import com.hccake.ballcat.system.model.vo.SysDictItemPageVO;
import com.hccake.ballcat.system.model.vo.SysDictPageVO;
import com.hccake.ballcat.system.service.SysDictItemService;
import com.hccake.ballcat.system.service.SysDictService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDictManager {
    private final SysDictService sysDictService;
    private final SysDictItemService sysDictItemService;
    private final ApplicationEventPublisher eventPublisher;

    public PageResult<SysDictPageVO> dictPage(PageParam pageParam, SysDictQO sysDictQO) {
        return this.sysDictService.queryPage(pageParam, sysDictQO);
    }

    public boolean dictSave(SysDict sysDict) {
        sysDict.setHashCode(IdUtil.fastSimpleUUID());
        return this.sysDictService.save(sysDict);
    }

    public boolean updateDictById(SysDict sysDict) {
        SysDict dict = (SysDict)this.sysDictService.getById(sysDict.getId());
        sysDict.setHashCode(IdUtil.fastSimpleUUID());
        boolean result = this.sysDictService.updateById(sysDict);
        if (result) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DictChangeEvent(dict.getCode()));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeDictById(Long id) {
        SysDict dict = (SysDict)this.sysDictService.getById(id);
        String dictCode = dict.getCode();
        Assert.isFalse((boolean)this.sysDictItemService.exist(dictCode), () -> new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u8be5\u5b57\u5178\u4e0b\u5b58\u5728\u5b57\u5178\u9879\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
        Assert.isTrue((boolean)this.sysDictService.removeById(id), () -> new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u5b57\u5178\u5220\u9664\u5f02\u5e38"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDictItemStatusById(Long itemId, Integer status) {
        SysDictItem dictItem = (SysDictItem)this.sysDictItemService.getById(itemId);
        Assert.notNull((Object)dictItem, () -> new BusinessException(BaseResultCode.LOGIC_CHECK_ERROR.getCode().intValue(), "\u9519\u8bef\u7684\u5b57\u5178\u9879 id\uff1a" + itemId));
        SysDictItem entity = new SysDictItem();
        entity.setId(itemId);
        entity.setStatus(status);
        Assert.isTrue((boolean)this.sysDictItemService.updateById(entity), () -> new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u5b57\u5178\u9879\u72b6\u6001\u66f4\u65b0\u5f02\u5e38"));
        String dictCode = dictItem.getDictCode();
        Assert.isTrue((boolean)this.sysDictService.updateHashCode(dictCode), () -> new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u5b57\u5178 Hash \u66f4\u65b0\u5f02\u5e38"));
        this.eventPublisher.publishEvent((ApplicationEvent)new DictChangeEvent(dictCode));
    }

    public PageResult<SysDictItemPageVO> dictItemPage(PageParam pageParam, String dictCode) {
        return this.sysDictItemService.queryPage(pageParam, dictCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveDictItem(SysDictItemDTO sysDictItemDTO) {
        String dictCode = sysDictItemDTO.getDictCode();
        if (!this.sysDictService.updateHashCode(dictCode)) {
            return false;
        }
        SysDictItem sysDictItem = SysDictItemConverter.INSTANCE.dtoToPo(sysDictItemDTO);
        boolean result = this.sysDictItemService.save(sysDictItem);
        if (result) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DictChangeEvent(dictCode));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateDictItemById(SysDictItemDTO sysDictItemDTO) {
        String dictCode = sysDictItemDTO.getDictCode();
        if (!this.sysDictService.updateHashCode(dictCode)) {
            return false;
        }
        SysDictItem sysDictItem = SysDictItemConverter.INSTANCE.dtoToPo(sysDictItemDTO);
        boolean result = this.sysDictItemService.updateById(sysDictItem);
        if (result) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DictChangeEvent(dictCode));
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeDictItemById(Long id) {
        SysDictItem dictItem = (SysDictItem)this.sysDictItemService.getById(id);
        String dictCode = dictItem.getDictCode();
        if (!this.sysDictService.updateHashCode(dictCode)) {
            return false;
        }
        boolean result = this.sysDictItemService.removeById(id);
        if (result) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DictChangeEvent(dictCode));
        }
        return true;
    }

    public List<DictDataVO> queryDictDataAndHashVO(String[] dictCodes) {
        List<SysDict> sysDictList = this.sysDictService.listByCodes(dictCodes);
        if (CollUtil.isEmpty(sysDictList)) {
            return new ArrayList<DictDataVO>();
        }
        ArrayList<DictDataVO> list = new ArrayList<DictDataVO>();
        for (SysDict sysDict : sysDictList) {
            List<SysDictItem> dictItems = this.sysDictItemService.listByDictCode(sysDict.getCode());
            List setDictItems = dictItems.stream().sorted(Comparator.comparingInt(SysDictItem::getSort)).map(arg_0 -> ((SysDictItemConverter)SysDictItemConverter.INSTANCE).poToItemVo(arg_0)).collect(Collectors.toList());
            DictDataVO dictDataVO = new DictDataVO();
            dictDataVO.setValueType(sysDict.getValueType());
            dictDataVO.setDictCode(sysDict.getCode());
            dictDataVO.setHashCode(sysDict.getHashCode());
            dictDataVO.setDictItems(setDictItems);
            list.add(dictDataVO);
        }
        return list;
    }

    public List<String> invalidDictHash(Map<String, String> dictHashCode) {
        List<SysDict> byCode = this.sysDictService.listByCodes(dictHashCode.keySet().toArray(new String[0]));
        return byCode.stream().filter(x -> !((String)dictHashCode.get(x.getCode())).equals(x.getHashCode())).map(SysDict::getCode).collect(Collectors.toList());
    }

    public SysDictManager(SysDictService sysDictService, SysDictItemService sysDictItemService, ApplicationEventPublisher eventPublisher) {
        this.sysDictService = sysDictService;
        this.sysDictItemService = sysDictItemService;
        this.eventPublisher = eventPublisher;
    }
}

