/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.system.mapper.SysUserRoleMapper;
import com.hccake.ballcat.system.model.entity.SysRole;
import com.hccake.ballcat.system.model.entity.SysUserRole;
import com.hccake.ballcat.system.model.qo.RoleBindUserQO;
import com.hccake.ballcat.system.model.vo.RoleBindUserVO;
import com.hccake.ballcat.system.service.SysUserRoleService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserRoleServiceImpl
extends ExtendServiceImpl<SysUserRoleMapper, SysUserRole>
implements SysUserRoleService {
    private static final Logger log = LoggerFactory.getLogger(SysUserRoleServiceImpl.class);

    @Override
    public boolean deleteByUserId(Long userId) {
        return ((SysUserRoleMapper)this.baseMapper).deleteByUserId(userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserRoles(@NonNull Long userId, @NonNull List<String> roleCodes) {
        boolean existsRoleBind = ((SysUserRoleMapper)this.baseMapper).existsRoleBind(userId, null);
        if (existsRoleBind) {
            boolean deleteSuccess = ((SysUserRoleMapper)this.baseMapper).deleteByUserId(userId);
            Assert.isTrue((boolean)deleteSuccess, () -> {
                log.error("[updateUserRoles] \u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff0cuserId\uff1a{}\uff0croleCodes\uff1a{}", (Object)userId, (Object)roleCodes);
                return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5931\u8d25");
            });
        }
        if (CollectionUtil.isEmpty(roleCodes)) {
            return true;
        }
        return this.addUserRoles(userId, roleCodes);
    }

    @Override
    public boolean addUserRoles(@NonNull Long userId, @NonNull List<String> roleCodes) {
        List<SysUserRole> list = this.prodSysUserRoles(userId, roleCodes);
        boolean insertSuccess = SqlHelper.retBool((Integer)((SysUserRoleMapper)this.baseMapper).insertBatchSomeColumn(list));
        Assert.isTrue((boolean)insertSuccess, () -> {
            log.error("[addUserRoles] \u63d2\u5165\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff0cuserId\uff1a{}\uff0croleCodes\uff1a{}", (Object)userId, (Object)roleCodes);
            return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u63d2\u5165\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5931\u8d25");
        });
        return insertSuccess;
    }

    private List<SysUserRole> prodSysUserRoles(Long userId, List<String> roleCodes) {
        ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
        for (String roleCode : roleCodes) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(userId);
            sysUserRole.setRoleCode(roleCode);
            list.add(sysUserRole);
        }
        return list;
    }

    @Override
    public List<SysRole> listRoles(Long userId) {
        return ((SysUserRoleMapper)this.baseMapper).listRoleByUserId(userId);
    }

    @Override
    public PageResult<RoleBindUserVO> queryUserPageByRoleCode(PageParam pageParam, RoleBindUserQO roleBindUserQO) {
        return ((SysUserRoleMapper)this.baseMapper).queryUserPageByRoleCode(pageParam, roleBindUserQO);
    }

    @Override
    public boolean unbindRoleUser(Long userId, String roleCode) {
        return !((SysUserRoleMapper)this.baseMapper).existsRoleBind(userId, roleCode) || ((SysUserRoleMapper)this.baseMapper).deleteUserRole(userId, roleCode);
    }
}

