/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.domain.SelectData;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.file.service.FileService;
import com.hccake.ballcat.system.checker.AdminUserChecker;
import com.hccake.ballcat.system.component.PasswordHelper;
import com.hccake.ballcat.system.constant.SysUserConst;
import com.hccake.ballcat.system.converter.SysUserConverter;
import com.hccake.ballcat.system.event.UserCreatedEvent;
import com.hccake.ballcat.system.event.UserOrganizationChangeEvent;
import com.hccake.ballcat.system.mapper.SysUserMapper;
import com.hccake.ballcat.system.model.dto.SysUserDTO;
import com.hccake.ballcat.system.model.dto.SysUserScope;
import com.hccake.ballcat.system.model.dto.UserInfoDTO;
import com.hccake.ballcat.system.model.entity.SysMenu;
import com.hccake.ballcat.system.model.entity.SysRole;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.model.qo.SysUserQO;
import com.hccake.ballcat.system.model.vo.SysUserPageVO;
import com.hccake.ballcat.system.service.SysMenuService;
import com.hccake.ballcat.system.service.SysRoleService;
import com.hccake.ballcat.system.service.SysUserRoleService;
import com.hccake.ballcat.system.service.SysUserService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysUserServiceImpl
extends ExtendServiceImpl<SysUserMapper, SysUser>
implements SysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    private final FileService fileService;
    private final SysMenuService sysMenuService;
    private final SysUserRoleService sysUserRoleService;
    private final AdminUserChecker adminUserChecker;
    private final SysRoleService sysRoleService;
    private final ApplicationEventPublisher publisher;
    private final PasswordHelper passwordHelper;

    @Override
    public PageResult<SysUserPageVO> queryPage(PageParam pageParam, SysUserQO qo) {
        return ((SysUserMapper)this.baseMapper).queryPage(pageParam, qo);
    }

    @Override
    public SysUser getByUsername(String username) {
        return ((SysUserMapper)this.baseMapper).selectByUsername(username);
    }

    @Override
    public UserInfoDTO findUserInfo(SysUser sysUser) {
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setSysUser(sysUser);
        List<SysRole> roleList = this.adminUserChecker.isAdminUser(sysUser) ? this.sysRoleService.list() : this.sysUserRoleService.listRoles(sysUser.getUserId());
        HashSet<String> roleCodes = new HashSet<String>();
        for (SysRole role : roleList) {
            roleCodes.add(role.getCode());
        }
        userInfoDTO.setRoles(new HashSet<SysRole>(roleList));
        userInfoDTO.setRoleCodes(roleCodes);
        HashSet permissions = new HashSet();
        HashSet<SysMenu> menus = new HashSet<SysMenu>();
        for (String roleCode : roleCodes) {
            List<SysMenu> sysMenuList = this.sysMenuService.listByRoleCode(roleCode);
            menus.addAll(sysMenuList);
            List permissionList = sysMenuList.stream().map(SysMenu::getPermission).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
            permissions.addAll(permissionList);
        }
        userInfoDTO.setMenus(menus);
        userInfoDTO.setPermissions(permissions);
        return userInfoDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addSysUser(SysUserDTO sysUserDto) {
        SysUser sysUser = SysUserConverter.INSTANCE.dtoToPo(sysUserDto);
        sysUser.setType(SysUserConst.Type.SYSTEM.getValue());
        String rawPassword = sysUserDto.getPassword();
        String encodedPassword = this.passwordHelper.encode(rawPassword);
        sysUser.setPassword(encodedPassword);
        boolean insertSuccess = SqlHelper.retBool((Integer)((SysUserMapper)this.baseMapper).insert(sysUser));
        Assert.isTrue((boolean)insertSuccess, () -> {
            log.error("[addSysUser] \u6570\u636e\u63d2\u5165\u7cfb\u7edf\u7528\u6237\u8868\u5931\u8d25\uff0cuser\uff1a{}", (Object)sysUserDto);
            return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u6570\u636e\u63d2\u5165\u7cfb\u7edf\u7528\u6237\u8868\u5931\u8d25");
        });
        List roleCodes = sysUserDto.getRoleCodes();
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            boolean addUserRoleSuccess = this.sysUserRoleService.addUserRoles(sysUser.getUserId(), roleCodes);
            Assert.isTrue((boolean)addUserRoleSuccess, () -> {
                log.error("[addSysUser] \u66f4\u65b0\u7528\u6237\u89d2\u8272\u4fe1\u606f\u5931\u8d25\uff0cuser\uff1a{}\uff0c roleCodes: {}", (Object)sysUserDto, (Object)roleCodes);
                return new BusinessException(BaseResultCode.UPDATE_DATABASE_ERROR.getCode().intValue(), "\u66f4\u65b0\u7528\u6237\u89d2\u8272\u4fe1\u606f\u5931\u8d25");
            });
        }
        this.publisher.publishEvent((Object)new UserCreatedEvent(sysUser, sysUserDto.getRoleCodes()));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateSysUser(SysUserDTO sysUserDTO) {
        SysUser entity = SysUserConverter.INSTANCE.dtoToPo(sysUserDTO);
        Assert.isTrue((boolean)this.adminUserChecker.hasModifyPermission(entity), (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5141\u8bb8\u4fee\u6539!", (Object[])new Object[0]);
        Long currentOrganizationId = entity.getOrganizationId();
        if (currentOrganizationId == null) {
            return SqlHelper.retBool((Integer)((SysUserMapper)this.baseMapper).updateById(entity));
        }
        Long userId = entity.getUserId();
        SysUser oldUser = (SysUser)((SysUserMapper)this.baseMapper).selectById(userId);
        Assert.notNull((Object)oldUser, (String)"\u4fee\u6539\u7528\u6237\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object[])new Object[]{userId});
        Long originOrganizationId = oldUser.getOrganizationId();
        boolean organizationIdModified = !currentOrganizationId.equals(originOrganizationId);
        boolean isUpdateSuccess = SqlHelper.retBool((Integer)((SysUserMapper)this.baseMapper).updateById(entity));
        if (isUpdateSuccess && organizationIdModified) {
            this.publisher.publishEvent((Object)new UserOrganizationChangeEvent(userId, originOrganizationId, currentOrganizationId));
        }
        return isUpdateSuccess;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateUserScope(Long userId, SysUserScope sysUserScope) {
        return this.sysUserRoleService.updateUserRoles(userId, sysUserScope.getRoleCodes());
    }

    @Override
    public boolean deleteByUserId(Long userId) {
        Assert.isFalse((boolean)this.adminUserChecker.isAdminUser((SysUser)this.getById(userId)), (String)"\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u5220\u9664!", (Object[])new Object[0]);
        return SqlHelper.retBool((Integer)((SysUserMapper)this.baseMapper).deleteById(userId));
    }

    @Override
    public boolean updatePassword(Long userId, String rawPassword) {
        Assert.isTrue((boolean)this.adminUserChecker.hasModifyPermission((SysUser)this.getById(userId)), (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5141\u8bb8\u4fee\u6539!", (Object[])new Object[0]);
        String encodedPassword = this.passwordHelper.encode(rawPassword);
        return ((SysUserMapper)this.baseMapper).updatePassword(userId, encodedPassword);
    }

    @Override
    public boolean updateUserStatusBatch(Collection<Long> userIds, Integer status) {
        List<SysUser> userList = ((SysUserMapper)this.baseMapper).listByUserIds(userIds);
        Assert.notEmpty(userList, (String)"\u66f4\u65b0\u7528\u6237\u72b6\u6001\u5931\u8d25\uff0c\u5f85\u66f4\u65b0\u7528\u6237\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
        Map userMap = userList.stream().collect(Collectors.toMap(SysUser::getUserId, Function.identity()));
        userIds.removeIf(id -> !this.adminUserChecker.hasModifyPermission((SysUser)userMap.get(id)));
        Assert.notEmpty(userIds, (String)"\u66f4\u65b0\u7528\u6237\u72b6\u6001\u5931\u8d25\uff0c\u65e0\u6743\u9650\u66f4\u65b0\u7528\u6237", (Object[])new Object[0]);
        return ((SysUserMapper)this.baseMapper).updateUserStatusBatch(userIds, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateAvatar(MultipartFile file, Long userId) throws IOException {
        Assert.isTrue((boolean)this.adminUserChecker.hasModifyPermission((SysUser)this.getById(userId)), (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5141\u8bb8\u4fee\u6539!", (Object[])new Object[0]);
        String objectName = "sysuser/" + userId + "/avatar/" + LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE) + "/" + IdUtil.fastSimpleUUID() + "." + FileUtil.extName((String)file.getOriginalFilename());
        objectName = this.fileService.upload(file.getInputStream(), objectName, file.getSize());
        SysUser sysUser = new SysUser();
        sysUser.setUserId(userId);
        sysUser.setAvatar(objectName);
        ((SysUserMapper)this.baseMapper).updateById(sysUser);
        return objectName;
    }

    @Override
    public List<SysUser> listByRoleCode(String roleCode) {
        return this.listByRoleCodes(Collections.singletonList(roleCode));
    }

    @Override
    public List<SysUser> listByRoleCodes(Collection<String> roleCodes) {
        return ((SysUserMapper)this.baseMapper).listByRoleCodes(roleCodes);
    }

    @Override
    public List<SysUser> listByOrganizationIds(Collection<Long> organizationIds) {
        return ((SysUserMapper)this.baseMapper).listByOrganizationIds(organizationIds);
    }

    @Override
    public List<SysUser> listByUserTypes(Collection<Integer> userTypes) {
        return ((SysUserMapper)this.baseMapper).listByUserTypes(userTypes);
    }

    @Override
    public List<SysUser> listByUserIds(Collection<Long> userIds) {
        return ((SysUserMapper)this.baseMapper).listByUserIds(userIds);
    }

    @Override
    public List<SelectData<Void>> listSelectData(Collection<Integer> userTypes) {
        return ((SysUserMapper)this.baseMapper).listSelectData(userTypes);
    }

    @Override
    public List<String> listRoleCodes(Long userId) {
        return this.sysUserRoleService.listRoles(userId).stream().map(SysRole::getCode).collect(Collectors.toList());
    }

    @Override
    public boolean existsForOrganization(Long organizationId) {
        return ((SysUserMapper)this.baseMapper).existsForOrganization(organizationId);
    }

    public SysUserServiceImpl(FileService fileService, SysMenuService sysMenuService, SysUserRoleService sysUserRoleService, AdminUserChecker adminUserChecker, SysRoleService sysRoleService, ApplicationEventPublisher publisher, PasswordHelper passwordHelper) {
        this.fileService = fileService;
        this.sysMenuService = sysMenuService;
        this.sysUserRoleService = sysUserRoleService;
        this.adminUserChecker = adminUserChecker;
        this.sysRoleService = sysRoleService;
        this.publisher = publisher;
        this.passwordHelper = passwordHelper;
    }
}

