/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.security.userdetails.User;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.system.converter.SysMenuConverter;
import com.hccake.ballcat.system.enums.SysMenuType;
import com.hccake.ballcat.system.model.dto.SysMenuCreateDTO;
import com.hccake.ballcat.system.model.dto.SysMenuUpdateDTO;
import com.hccake.ballcat.system.model.entity.SysMenu;
import com.hccake.ballcat.system.model.qo.SysMenuQO;
import com.hccake.ballcat.system.model.vo.SysMenuGrantVO;
import com.hccake.ballcat.system.model.vo.SysMenuPageVO;
import com.hccake.ballcat.system.model.vo.SysMenuRouterVO;
import com.hccake.ballcat.system.service.SysMenuService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/menu"})
@Tag(name="\u83dc\u5355\u6743\u9650\u7ba1\u7406")
public class SysMenuController {
    private final SysMenuService sysMenuService;

    @GetMapping(value={"/router"})
    @Operation(summary="\u52a8\u6001\u8def\u7531", description="\u52a8\u6001\u8def\u7531")
    public R<List<SysMenuRouterVO>> getUserPermission() {
        User user = SecurityUtils.getUser();
        Map attributes = user.getAttributes();
        Object rolesObject = attributes.get("roleCodes");
        if (!(rolesObject instanceof Collection)) {
            return R.ok(new ArrayList());
        }
        Collection roleCodes = (Collection)rolesObject;
        if (CollUtil.isEmpty((Collection)roleCodes)) {
            return R.ok(new ArrayList());
        }
        HashSet all = new HashSet();
        roleCodes.forEach(roleCode -> all.addAll(this.sysMenuService.listByRoleCode(roleCode)));
        List menuVOList = all.stream().filter(menuVo -> SysMenuType.BUTTON.getValue() != menuVo.getType().intValue()).sorted(Comparator.comparingInt(SysMenu::getSort)).map(arg_0 -> ((SysMenuConverter)SysMenuConverter.INSTANCE).poToRouterVo(arg_0)).collect(Collectors.toList());
        return R.ok(menuVOList);
    }

    @GetMapping(value={"/list"})
    @PreAuthorize(value="@per.hasPermission('system:menu:read')")
    @Operation(summary="\u67e5\u8be2\u83dc\u5355\u5217\u8868", description="\u67e5\u8be2\u83dc\u5355\u5217\u8868")
    public R<List<SysMenuPageVO>> getSysMenuPage(SysMenuQO sysMenuQO) {
        List sysMenus = this.sysMenuService.listOrderBySort(sysMenuQO);
        if (CollUtil.isEmpty((Collection)sysMenus)) {
            R.ok(new ArrayList());
        }
        List voList = sysMenus.stream().map(arg_0 -> ((SysMenuConverter)SysMenuConverter.INSTANCE).poToPageVo(arg_0)).collect(Collectors.toList());
        return R.ok(voList);
    }

    @GetMapping(value={"/grant-list"})
    @PreAuthorize(value="@per.hasPermission('system:menu:read')")
    @Operation(summary="\u67e5\u8be2\u6388\u6743\u83dc\u5355\u5217\u8868", description="\u67e5\u8be2\u6388\u6743\u83dc\u5355\u5217\u8868")
    public R<List<SysMenuGrantVO>> getSysMenuGrantList() {
        List sysMenus = this.sysMenuService.list();
        if (CollUtil.isEmpty((Collection)sysMenus)) {
            R.ok(new ArrayList());
        }
        List voList = sysMenus.stream().map(arg_0 -> ((SysMenuConverter)SysMenuConverter.INSTANCE).poToGrantVo(arg_0)).collect(Collectors.toList());
        return R.ok(voList);
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u83dc\u5355\u6743\u9650")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('system:menu:add')")
    @Operation(summary="\u65b0\u589e\u83dc\u5355\u6743\u9650", description="\u65b0\u589e\u83dc\u5355\u6743\u9650")
    public R<Void> save(@Valid @RequestBody SysMenuCreateDTO sysMenuCreateDTO) {
        return this.sysMenuService.create(sysMenuCreateDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u83dc\u5355\u6743\u9650\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u83dc\u5355\u6743\u9650")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('system:menu:edit')")
    @Operation(summary="\u4fee\u6539\u83dc\u5355\u6743\u9650", description="\u4fee\u6539\u83dc\u5355\u6743\u9650")
    public R<Void> updateById(@RequestBody SysMenuUpdateDTO sysMenuUpdateDTO) {
        this.sysMenuService.update(sysMenuUpdateDTO);
        return R.ok();
    }

    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u83dc\u5355\u6743\u9650")
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:menu:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u83dc\u5355\u6743\u9650", description="\u901a\u8fc7id\u5220\u9664\u83dc\u5355\u6743\u9650")
    public R<Void> removeById(@PathVariable(value="id") Long id) {
        return this.sysMenuService.removeById((Serializable)id) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u901a\u8fc7id\u5220\u9664\u83dc\u5355\u6743\u9650\u5931\u8d25");
    }

    public SysMenuController(SysMenuService sysMenuService) {
        this.sysMenuService = sysMenuService;
    }
}

