/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.system.converter.SysOrganizationConverter;
import com.hccake.ballcat.system.model.dto.SysOrganizationDTO;
import com.hccake.ballcat.system.model.entity.SysOrganization;
import com.hccake.ballcat.system.model.qo.SysOrganizationQO;
import com.hccake.ballcat.system.model.vo.SysOrganizationTree;
import com.hccake.ballcat.system.model.vo.SysOrganizationVO;
import com.hccake.ballcat.system.service.SysOrganizationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/organization"})
@Tag(name="\u7ec4\u7ec7\u67b6\u6784\u7ba1\u7406")
public class SysOrganizationController {
    private final SysOrganizationService sysOrganizationService;

    @GetMapping(value={"/list"})
    @PreAuthorize(value="@per.hasPermission('system:organization:read')")
    @Operation(summary="\u7ec4\u7ec7\u67b6\u6784\u5217\u8868\u67e5\u8be2")
    public R<List<SysOrganizationVO>> listOrganization() {
        List list = this.sysOrganizationService.list();
        if (CollUtil.isEmpty((Collection)list)) {
            return R.ok(new ArrayList());
        }
        List voList = list.stream().sorted(Comparator.comparingInt(SysOrganization::getSort)).map(arg_0 -> ((SysOrganizationConverter)SysOrganizationConverter.INSTANCE).poToVo(arg_0)).collect(Collectors.toList());
        return R.ok(voList);
    }

    @GetMapping(value={"/tree"})
    @PreAuthorize(value="@per.hasPermission('system:organization:read')")
    @Operation(summary="\u7ec4\u7ec7\u67b6\u6784\u6811\u67e5\u8be2")
    public R<List<SysOrganizationTree>> getOrganizationTree(SysOrganizationQO qo) {
        return R.ok((Object)this.sysOrganizationService.listTree(qo));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u7ec4\u7ec7\u67b6\u6784")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('system:organization:add')")
    @Operation(summary="\u65b0\u589e\u7ec4\u7ec7\u67b6\u6784")
    public R<Void> save(@RequestBody SysOrganizationDTO sysOrganizationDTO) {
        return this.sysOrganizationService.create(sysOrganizationDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u7ec4\u7ec7\u67b6\u6784")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('system:organization:edit')")
    @Operation(summary="\u4fee\u6539\u7ec4\u7ec7\u67b6\u6784")
    public R<Void> updateById(@RequestBody SysOrganizationDTO sysOrganizationDTO) {
        return this.sysOrganizationService.update(sysOrganizationDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25");
    }

    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u7ec4\u7ec7\u67b6\u6784")
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:organization:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u7ec4\u7ec7\u67b6\u6784")
    public R<Void> removeById(@PathVariable(value="id") Long id) {
        return this.sysOrganizationService.removeById((Serializable)id) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u901a\u8fc7id\u5220\u9664\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u6821\u6b63\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u548c\u6df1\u5ea6")
    @PatchMapping(value={"/revised"})
    @PreAuthorize(value="@per.hasPermission('system:organization:revised')")
    @Operation(summary="\u6821\u6b63\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u548c\u6df1\u5ea6")
    public R<Void> revisedHierarchyAndPath() {
        return this.sysOrganizationService.revisedHierarchyAndPath() ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u6821\u6b63\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u548c\u6df1\u5ea6\u5931\u8d25");
    }

    public SysOrganizationController(SysOrganizationService sysOrganizationService) {
        this.sysOrganizationService = sysOrganizationService;
    }
}

