/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.domain.SelectData;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.system.constant.SysRoleConst;
import com.hccake.ballcat.system.converter.SysRoleConverter;
import com.hccake.ballcat.system.model.dto.SysRoleUpdateDTO;
import com.hccake.ballcat.system.model.entity.SysMenu;
import com.hccake.ballcat.system.model.entity.SysRole;
import com.hccake.ballcat.system.model.qo.RoleBindUserQO;
import com.hccake.ballcat.system.model.qo.SysRoleQO;
import com.hccake.ballcat.system.model.vo.RoleBindUserVO;
import com.hccake.ballcat.system.model.vo.SysRolePageVO;
import com.hccake.ballcat.system.service.SysMenuService;
import com.hccake.ballcat.system.service.SysRoleMenuService;
import com.hccake.ballcat.system.service.SysRoleService;
import com.hccake.ballcat.system.service.SysUserRoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/role"})
@Tag(name="\u89d2\u8272\u7ba1\u7406\u6a21\u5757")
public class SysRoleController {
    private final SysRoleService sysRoleService;
    private final SysMenuService sysMenuService;
    private final SysUserRoleService sysUserRoleService;
    private final SysRoleMenuService sysRoleMenuService;

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('system:role:read')")
    public R<PageResult<SysRolePageVO>> getRolePage(@Validated PageParam pageParam, SysRoleQO sysRoleQo) {
        return R.ok((Object)this.sysRoleService.queryPage(pageParam, sysRoleQo));
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@per.hasPermission('system:role:read')")
    public R<SysRole> getById(@PathVariable(value="id") Long id) {
        return R.ok((Object)this.sysRoleService.getById((Serializable)id));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u7cfb\u7edf\u89d2\u8272")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('system:role:add')")
    @Operation(summary="\u65b0\u589e\u7cfb\u7edf\u89d2\u8272", description="\u65b0\u589e\u7cfb\u7edf\u89d2\u8272")
    public R<Boolean> save(@Valid @RequestBody SysRole sysRole) {
        return this.sysRoleService.save((Object)sysRole) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u5efa\u89d2\u8272\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u7cfb\u7edf\u89d2\u8272")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('system:role:edit')")
    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u89d2\u8272", description="\u4fee\u6539\u7cfb\u7edf\u89d2\u8272")
    public R<Boolean> update(@Valid @RequestBody SysRoleUpdateDTO roleUpdateDTO) {
        SysRole sysRole = SysRoleConverter.INSTANCE.dtoToPo(roleUpdateDTO);
        return R.ok((Object)this.sysRoleService.updateById((Object)sysRole));
    }

    @DeleteMapping(value={"/{id}"})
    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u89d2\u8272")
    @PreAuthorize(value="@per.hasPermission('system:role:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u89d2\u8272", description="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u89d2\u8272")
    public R<Boolean> removeById(@PathVariable(value="id") Long id) {
        SysRole oldRole = (SysRole)this.sysRoleService.getById((Serializable)id);
        if (oldRole == null) {
            return R.ok();
        }
        if (SysRoleConst.Type.SYSTEM.getValue().equals(oldRole.getType())) {
            return R.failed((ResultCode)BaseResultCode.LOGIC_CHECK_ERROR, (String)"\u7cfb\u7edf\u89d2\u8272\u4e0d\u5141\u8bb8\u88ab\u5220\u9664!");
        }
        return R.ok((Object)this.sysRoleService.removeById((Serializable)id));
    }

    @GetMapping(value={"/list"})
    public R<List<SysRole>> listRoles() {
        return R.ok((Object)this.sysRoleService.list());
    }

    @PutMapping(value={"/permission/code/{roleCode}"})
    @UpdateOperationLogging(msg="\u66f4\u65b0\u89d2\u8272\u6743\u9650")
    @PreAuthorize(value="@per.hasPermission('system:role:grant')")
    @Operation(summary="\u66f4\u65b0\u89d2\u8272\u6743\u9650", description="\u66f4\u65b0\u89d2\u8272\u6743\u9650")
    public R<Boolean> savePermissionIds(@PathVariable(value="roleCode") String roleCode, @RequestBody Long[] permissionIds) {
        return R.ok((Object)this.sysRoleMenuService.saveRoleMenus(roleCode, permissionIds));
    }

    @GetMapping(value={"/permission/code/{roleCode}"})
    public R<List<Long>> getPermissionIds(@PathVariable(value="roleCode") String roleCode) {
        List sysMenus = this.sysMenuService.listByRoleCode(roleCode);
        List menuIds = sysMenus.stream().map(SysMenu::getId).collect(Collectors.toList());
        return R.ok(menuIds);
    }

    @GetMapping(value={"/select"})
    public R<List<SelectData<Void>>> listSelectData() {
        return R.ok((Object)this.sysRoleService.listSelectData());
    }

    @GetMapping(value={"/user/page"})
    @PreAuthorize(value="@per.hasPermission('system:role:grant')")
    @Operation(summary="\u67e5\u770b\u5df2\u6388\u6743\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5217\u8868", description="\u67e5\u770b\u5df2\u6388\u6743\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5217\u8868")
    public R<PageResult<RoleBindUserVO>> queryUserPageByRoleCode(PageParam pageParam, @Valid RoleBindUserQO roleBindUserQO) {
        return R.ok((Object)this.sysUserRoleService.queryUserPageByRoleCode(pageParam, roleBindUserQO));
    }

    @DeleteMapping(value={"/user"})
    @PreAuthorize(value="@per.hasPermission('system:role:grant')")
    @Operation(summary="\u89e3\u7ed1\u4e0e\u7528\u6237\u7ed1\u5b9a\u5173\u7cfb", description="\u89e3\u7ed1\u4e0e\u7528\u6237\u7ed1\u5b9a\u5173\u7cfb")
    public R<Boolean> unbindRoleUser(@RequestParam(value="userId") Long userId, @RequestParam(value="roleCode") String roleCode) {
        return R.ok((Object)this.sysUserRoleService.unbindRoleUser(userId, roleCode));
    }

    public SysRoleController(SysRoleService sysRoleService, SysMenuService sysMenuService, SysUserRoleService sysUserRoleService, SysRoleMenuService sysRoleMenuService) {
        this.sysRoleService = sysRoleService;
        this.sysMenuService = sysMenuService;
        this.sysUserRoleService = sysUserRoleService;
        this.sysRoleMenuService = sysRoleMenuService;
    }
}

