/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.system.controller;

import com.hccake.ballcat.common.core.validation.group.CreateGroup;
import com.hccake.ballcat.common.core.validation.group.UpdateGroup;
import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.domain.SelectData;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import com.hccake.ballcat.system.component.PasswordHelper;
import com.hccake.ballcat.system.constant.SysUserConst;
import com.hccake.ballcat.system.converter.SysUserConverter;
import com.hccake.ballcat.system.model.dto.SysUserDTO;
import com.hccake.ballcat.system.model.dto.SysUserPassDTO;
import com.hccake.ballcat.system.model.dto.SysUserScope;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.model.qo.SysUserQO;
import com.hccake.ballcat.system.model.vo.SysUserInfo;
import com.hccake.ballcat.system.model.vo.SysUserPageVO;
import com.hccake.ballcat.system.service.SysUserRoleService;
import com.hccake.ballcat.system.service.SysUserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"/system/user"})
@Tag(name="\u7528\u6237\u7ba1\u7406\u6a21\u5757")
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    private final SysUserService sysUserService;
    private final SysUserRoleService sysUserRoleService;
    private final PasswordHelper passwordHelper;

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('system:user:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7cfb\u7edf\u7528\u6237")
    public R<PageResult<SysUserPageVO>> getUserPage(@Validated PageParam pageParam, SysUserQO qo) {
        return R.ok((Object)this.sysUserService.queryPage(pageParam, qo));
    }

    @GetMapping(value={"/select"})
    @PreAuthorize(value="@per.hasPermission('system:user:read')")
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e0b\u62c9\u5217\u8868\u6570\u636e")
    public R<List<SelectData<Void>>> listSelectData(@RequestParam(value="userTypes", required=false) List<Integer> userTypes) {
        return R.ok((Object)this.sysUserService.listSelectData(userTypes));
    }

    @GetMapping(value={"/{userId}"})
    @PreAuthorize(value="@per.hasPermission('system:user:read')")
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f")
    public R<SysUserInfo> getSysUserInfo(@PathVariable(value="userId") Long userId) {
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)userId);
        if (sysUser == null) {
            return R.ok();
        }
        SysUserInfo sysUserInfo = SysUserConverter.INSTANCE.poToInfo(sysUser);
        return R.ok((Object)sysUserInfo);
    }

    @PostMapping
    @CreateOperationLogging(msg="\u65b0\u589e\u7cfb\u7edf\u7528\u6237")
    @PreAuthorize(value="@per.hasPermission('system:user:add')")
    @Operation(summary="\u65b0\u589e\u7cfb\u7edf\u7528\u6237", description="\u65b0\u589e\u7cfb\u7edf\u7528\u6237")
    public R<Void> addSysUser(@Validated(value={Default.class, CreateGroup.class}) @RequestBody SysUserDTO sysUserDTO) {
        SysUser user = this.sysUserService.getByUsername(sysUserDTO.getUsername());
        if (user != null) {
            return R.failed((ResultCode)BaseResultCode.LOGIC_CHECK_ERROR, (String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        String rawPassword = this.passwordHelper.decodeAes(sysUserDTO.getPass());
        sysUserDTO.setPassword(rawPassword);
        if (this.passwordHelper.validateRule(rawPassword)) {
            return this.sysUserService.addSysUser(sysUserDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u7cfb\u7edf\u7528\u6237\u5931\u8d25");
        }
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)"\u5bc6\u7801\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u5219!");
    }

    @PutMapping
    @UpdateOperationLogging(msg="\u4fee\u6539\u7cfb\u7edf\u7528\u6237")
    @PreAuthorize(value="@per.hasPermission('system:user:edit')")
    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u7528\u6237", description="\u4fee\u6539\u7cfb\u7edf\u7528\u6237")
    public R<Void> updateUserInfo(@Validated(value={Default.class, UpdateGroup.class}) @RequestBody SysUserDTO sysUserDto) {
        return this.sysUserService.updateSysUser(sysUserDto) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5931\u8d25");
    }

    @DeleteMapping(value={"/{userId}"})
    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u7528\u6237")
    @PreAuthorize(value="@per.hasPermission('system:user:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u7528\u6237", description="\u901a\u8fc7id\u5220\u9664\u7cfb\u7edf\u7528\u6237")
    public R<Void> deleteByUserId(@PathVariable(value="userId") Long userId) {
        return this.sysUserService.deleteByUserId(userId) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u5220\u9664\u7cfb\u7edf\u7528\u6237\u5931\u8d25");
    }

    @GetMapping(value={"/scope/{userId}"})
    @PreAuthorize(value="@per.hasPermission('system:user:grant')")
    public R<SysUserScope> getUserRoleIds(@PathVariable(value="userId") Long userId) {
        List roleList = this.sysUserRoleService.listRoles(userId);
        ArrayList roleCodes = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)roleList)) {
            roleList.forEach(role -> roleCodes.add(role.getCode()));
        }
        SysUserScope sysUserScope = new SysUserScope();
        sysUserScope.setRoleCodes(roleCodes);
        return R.ok((Object)sysUserScope);
    }

    @PutMapping(value={"/scope/{userId}"})
    @UpdateOperationLogging(msg="\u7cfb\u7edf\u7528\u6237\u6388\u6743")
    @PreAuthorize(value="@per.hasPermission('system:user:grant')")
    @Operation(summary="\u7cfb\u7edf\u7528\u6237\u6388\u6743", description="\u7cfb\u7edf\u7528\u6237\u6388\u6743")
    public R<Void> updateUserScope(@PathVariable(value="userId") Long userId, @RequestBody SysUserScope sysUserScope) {
        return this.sysUserService.updateUserScope(userId, sysUserScope) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u7cfb\u7edf\u7528\u6237\u6388\u6743\u5931\u8d25");
    }

    @PutMapping(value={"/pass/{userId}"})
    @UpdateOperationLogging(msg="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5bc6\u7801")
    @PreAuthorize(value="@per.hasPermission('system:user:pass')")
    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5bc6\u7801", description="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5bc6\u7801")
    public R<Void> updateUserPass(@PathVariable(value="userId") Long userId, @RequestBody SysUserPassDTO sysUserPassDTO) {
        String pass = sysUserPassDTO.getPass();
        if (!pass.equals(sysUserPassDTO.getConfirmPass())) {
            return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)"\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4!");
        }
        String rawPassword = this.passwordHelper.decodeAes(pass);
        if (this.passwordHelper.validateRule(rawPassword)) {
            return this.sysUserService.updatePassword(userId, rawPassword) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u7528\u6237\u5bc6\u7801\u5931\u8d25\uff01");
        }
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)"\u5bc6\u7801\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u5219!");
    }

    @PutMapping(value={"/status"})
    @UpdateOperationLogging(msg="\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001")
    @PreAuthorize(value="@per.hasPermission('system:user:edit')")
    @Operation(summary="\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001", description="\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001")
    public R<Void> updateUserStatus(@NotEmpty(message="\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") @RequestBody @NotEmpty(message="\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") List<Long> userIds, @NotNull(message="\u7528\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="status") @NotNull(message="\u7528\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a") Integer status) {
        if (!SysUserConst.Status.NORMAL.getValue().equals(status) && !SysUserConst.Status.LOCKED.getValue().equals(status)) {
            throw new ValidationException("\u4e0d\u652f\u6301\u7684\u7528\u6237\u72b6\u6001\uff01");
        }
        return this.sysUserService.updateUserStatusBatch(userIds, status) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u6279\u91cf\u4fee\u6539\u7528\u6237\u72b6\u6001\uff01");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5934\u50cf")
    @PreAuthorize(value="@per.hasPermission('system:user:edit')")
    @PostMapping(value={"/avatar"})
    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5934\u50cf", description="\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5934\u50cf")
    public R<String> updateAvatar(@RequestParam(value="file") MultipartFile file, @RequestParam(value="userId") Long userId) {
        String objectName;
        try {
            objectName = this.sysUserService.updateAvatar(file, userId);
        }
        catch (IOException e) {
            log.error("\u4fee\u6539\u7cfb\u7edf\u7528\u6237\u5934\u50cf\u5f02\u5e38", (Throwable)e);
            return R.failed((ResultCode)BaseResultCode.FILE_UPLOAD_ERROR);
        }
        return R.ok((Object)objectName);
    }

    public SysUserController(SysUserService sysUserService, SysUserRoleService sysUserRoleService, PasswordHelper passwordHelper) {
        this.sysUserService = sysUserService;
        this.sysUserRoleService = sysUserRoleService;
        this.passwordHelper = passwordHelper;
    }
}

