/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang.ArrayUtils;

public class JsonUtils {
    private static final Gson GSON_PUT = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{JsonUtils.getPutExclusionStrategy()}).create();
    private static final Gson GSON_POST = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{JsonUtils.getPostExclusionStrategy()}).create();

    public static String getJsonForPut(Object object) {
        return GSON_PUT.toJson(object);
    }

    public static String getJsonForPost(Object object) {
        return GSON_POST.toJson(object);
    }

    private static ExclusionStrategy getPutExclusionStrategy() {
        return JsonUtils.getMethodExclusionStrategy(MethodType.PUT);
    }

    private static ExclusionStrategy getPostExclusionStrategy() {
        return JsonUtils.getMethodExclusionStrategy(MethodType.POST);
    }

    private static ExclusionStrategy getMethodExclusionStrategy(final MethodType methodType) {
        return new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                ExcludeFrom excludes = (ExcludeFrom)f.getAnnotation(ExcludeFrom.class);
                if (excludes != null) {
                    return ArrayUtils.contains((Object[])excludes.value(), (Object)((Object)methodType));
                }
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ExcludeFrom {
        public MethodType[] value();
    }

    public static enum MethodType {
        PUT,
        POST;

    }
}

