/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.hds.commons.json.JsonSubClassName;
import com.hds.commons.json.JsonSubClasses;
import java.io.IOException;
import java.util.Arrays;

public class SubClassTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        JsonSubClasses reference = clazz.getAnnotation(JsonSubClasses.class);
        if (reference != null) {
            return new SubClassTypeAdapter(gson, reference.value());
        }
        return null;
    }

    protected class SubClassTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Gson gson;
        private final Class<?>[] classes;

        public SubClassTypeAdapter(Gson gson, Class<?>[] classes) {
            this.gson = gson;
            this.classes = classes;
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            Class<?> clazz = value.getClass();
            out.name(this.getName(clazz));
            this.getAdapter(clazz).write(out, value);
            out.endObject();
        }

        public T read(JsonReader in) throws IOException {
            if (JsonToken.NULL == in.peek()) {
                in.nextNull();
                return null;
            }
            Object obj = null;
            in.beginObject();
            String name = in.nextName();
            for (Class<?> clazz : this.classes) {
                if (!name.equals(this.getName(clazz))) continue;
                obj = this.getAdapter(clazz).read(in);
                break;
            }
            if (obj == null) {
                throw new JsonParseException("Could not find class with name " + name + " in references " + Arrays.toString(this.classes));
            }
            in.endObject();
            return (T)obj;
        }

        private TypeAdapter<T> getAdapter(Class<?> clazz) {
            return this.gson.getDelegateAdapter((TypeAdapterFactory)SubClassTypeAdapterFactory.this, TypeToken.get(clazz));
        }

        private String getName(Class<?> clazz) {
            JsonSubClassName referenceName = clazz.getAnnotation(JsonSubClassName.class);
            String name = referenceName != null ? referenceName.value() : clazz.getSimpleName();
            return name;
        }
    }
}

