/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.strings;

import com.hds.commons.exception.InvalidInputException;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.StringPrepParseException;

public final class StringNormalizer {
    private StringNormalizer() {
    }

    public static String normalize(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        String normalizedStr = input;
        normalizedStr = Normalizer.normalize((String)normalizedStr, (Normalizer.Mode)Normalizer.NFD);
        normalizedStr = UCharacter.foldCase((String)normalizedStr, (boolean)true);
        return normalizedStr;
    }

    public static String idnToAce(String input) throws InvalidInputException {
        try {
            return IDNA.convertIDNToASCII((String)input, (int)4).toString();
        }
        catch (StringPrepParseException e) {
            throw new InvalidInputException("Provided input for conversion to ACE was rejected by IDNA", e);
        }
    }

    public static String idnToUnicode(String input) throws InvalidInputException {
        try {
            return IDNA.convertIDNToUnicode((String)input, (int)4).toString();
        }
        catch (StringPrepParseException e) {
            throw new InvalidInputException("Provided input for conversion to unicode was rejected by IDNA", e);
        }
    }
}

