/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.io.IOUtils;
import com.hds.commons.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

public class Base64Utils {
    private static final int CHUNK_SIZE = 76;
    private static final byte[] LINE_SEPARATOR = new byte[]{10};

    public static String encode(byte[] data) {
        return Base64Utils.encode(data, LINE_SEPARATOR);
    }

    public static String encode(byte[] data, byte[] lineSeparator) {
        Base64 encoder = new Base64(76, lineSeparator);
        String result = encoder.encodeToString(data);
        return result.trim();
    }

    public static String encodeForUI(byte[] data) {
        return Base64.encodeBase64URLSafeString((byte[])data);
    }

    public static void encode(byte[] data, OutputStream outstream) throws IOException {
        try (Base64OutputStream out = new Base64OutputStream(outstream, true, 76, LINE_SEPARATOR);){
            out.write(data);
        }
    }

    public static String encodeAsString(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static String decode(String data) {
        try {
            return StringUtils.getDefaultEncodedString(Base64.decodeBase64((byte[])StringUtils.getDefaultEncodedBytes(data)));
        }
        catch (IllegalArgumentException e) {
            return new String(Base64.decodeBase64((byte[])data.getBytes()));
        }
    }

    public static byte[] decodeForURL(String data) {
        try {
            return Base64.decodeBase64((byte[])StringUtils.getDefaultEncodedBytes(data));
        }
        catch (IllegalArgumentException e) {
            return Base64.decodeBase64((byte[])data.getBytes());
        }
    }

    public static String decodeForUI(String data) {
        return Base64Utils.decode(data);
    }

    public static byte[] decodeBuffer(String data) {
        return Base64.decodeBase64((String)data);
    }

    public static byte[] decodeBuffer(InputStream instream) throws IOException {
        try (Base64InputStream bis = new Base64InputStream(instream);){
            byte[] byArray = IOUtils.getStreamContentsAsBytes((InputStream)bis);
            return byArray;
        }
    }
}

