/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Preconditions;
import com.hds.commons.util.ByteBufferPoolBase;
import com.hds.commons.util.MemoryPool;
import com.hds.commons.util.logging.RISLogger;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class ByteBufferPool
extends ByteBufferPoolBase
implements MemoryPool<ByteBuffer> {
    private static final RISLogger log = RISLogger.getLogger();
    private final ByteBufferPoolBase.Exhaustion exhaustion;
    private final ByteBufferPoolBase.AllocationCallbacks allocationCallbacks = new ByteBufferPoolBase.AllocationCallbacks(){

        @Override
        public boolean preAllocation(int capacity) {
            return true;
        }

        @Override
        public boolean postAllocation(int requestedCapacity, ByteBuffer buffer) {
            return true;
        }

        @Override
        public void allocationFailure(int capacity) {
        }

        @Override
        public void exhausted(int capacity, int retry) {
            if (retry % ByteBufferPool.this.getRetryLogThreshold() == 0 && retry != 0) {
                log.log(Level.INFO, "{0}: Buffer beyond max {1} checkedOut {2} allocating {3} retry {4}", (Object)ByteBufferPool.this.name, ByteBufferPool.this.maxMemorySize, ByteBufferPool.this.checkedOut(), (long)capacity, (long)retry);
            }
        }
    };

    public static ByteBufferPool create(long maxMemorySize, long minMemorySize) {
        return ByteBufferPool.createBufferPool(ByteBufferPool.createConfiguration(maxMemorySize, minMemorySize));
    }

    public static PoolConfiguration createConfiguration(long maxMemorySize, long minMemorySize) {
        return new PoolConfiguration(maxMemorySize, minMemorySize);
    }

    public static ByteBufferPool createBufferPool(PoolConfiguration pc) {
        return new ByteBufferPool(pc);
    }

    protected ByteBufferPool(PoolConfiguration pc) {
        super(pc);
        this.exhaustion = pc.exhaustion;
    }

    public ByteBuffer allocateTempHeapBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public ByteBuffer allocateResource(int capacity) {
        return this.allocateResource(capacity, this.allocationCallbacks, this.exhaustion);
    }

    @Override
    public ByteBuffer tryAllocateResource(int capacity) {
        return this.allocateResource(capacity, this.allocationCallbacks, ByteBufferPoolBase.Exhaustion.NONE);
    }

    @Override
    public long getMaxPoolSizeInBytes() {
        return this.maxMemorySize;
    }

    @Override
    public long getMinPoolSizeInBytes() {
        return this.minMemorySize;
    }

    @Override
    public long getPoolIdleAgeoutMillis() {
        return this.ageoutTimeMillis;
    }

    @Override
    public void returnResource(ByteBuffer resource) {
        this.returnResource(resource, null);
    }

    public static class PoolConfiguration
    extends ByteBufferPoolBase.PoolConfigurationBase<PoolConfiguration> {
        private ByteBufferPoolBase.Exhaustion exhaustion = ByteBufferPoolBase.Exhaustion.NONE;

        private PoolConfiguration(long maxMemorySize, long minMemorySize) {
            super(maxMemorySize, minMemorySize);
        }

        @Deprecated
        public PoolConfiguration useHeapOnExhaustion(boolean useHeapOnExhaustion) {
            Preconditions.checkArgument((!useHeapOnExhaustion || this.exhaustion != ByteBufferPoolBase.Exhaustion.BLOCK ? 1 : 0) != 0);
            if (useHeapOnExhaustion) {
                this.exhaustion = ByteBufferPoolBase.Exhaustion.ALLOCATE_HEAP;
            } else if (this.exhaustion == ByteBufferPoolBase.Exhaustion.ALLOCATE_HEAP) {
                this.exhaustion = ByteBufferPoolBase.Exhaustion.NONE;
            }
            return this;
        }

        @Deprecated
        public PoolConfiguration blocking(boolean blocking) {
            Preconditions.checkArgument((!blocking || this.exhaustion != ByteBufferPoolBase.Exhaustion.ALLOCATE_HEAP ? 1 : 0) != 0);
            if (blocking) {
                this.exhaustion = ByteBufferPoolBase.Exhaustion.BLOCK;
            } else if (this.exhaustion == ByteBufferPoolBase.Exhaustion.BLOCK) {
                this.exhaustion = ByteBufferPoolBase.Exhaustion.NONE;
            }
            return this;
        }

        public PoolConfiguration exhaustion(ByteBufferPoolBase.Exhaustion exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        public ByteBufferPool create() {
            return ByteBufferPool.createBufferPool(this);
        }

        @Override
        PoolConfiguration instance() {
            return this;
        }
    }
}

