/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.hds.commons.cache.ExpiringInsertionMap;
import com.hds.commons.cache.ExpiringMap;
import com.hds.commons.util.DirectBufferAllocator;
import com.hds.commons.util.StorageUnit;
import com.hds.commons.util.logging.RISLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import sun.nio.ch.DirectBuffer;

public abstract class ByteBufferPoolBase {
    private static final RISLogger log = RISLogger.getLogger();
    public static final String DEBUG_TRACK_ALLOCATIONS = "hds.byteBufferPool.trackAlloc";
    public static final long BLOCK_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final Comparator<AllocCacheEntry> ALLOC_CACHE_ENTRY_COMPARATOR = new Comparator<AllocCacheEntry>(){

        @Override
        public int compare(AllocCacheEntry allocCacheEntry, AllocCacheEntry allocCacheEntry1) {
            return Long.compare(allocCacheEntry.allocTimestampNanos, allocCacheEntry1.allocTimestampNanos);
        }
    };
    private static final DirectBufferAllocator DEFAULT_ALLOCATER = new DirectBufferAllocator(){

        @Override
        public ByteBuffer allocate(int capacity) {
            return ByteBuffer.allocateDirect(capacity);
        }

        @Override
        public void deallocate(ByteBuffer byteBuffer) {
        }
    };
    final String name;
    final long maxMemorySize;
    final long minMemorySize;
    final long ageoutTimeMillis;
    private final AtomicLong currentAllocationSize = new AtomicLong();
    private final AtomicLong currentCheckedOutSize = new AtomicLong();
    private final ExpiringMap<BufferWrapper, BufferWrapper> ageoutCache;
    private final ConcurrentSkipListSet<BufferWrapper> availableSet = new ConcurrentSkipListSet();
    private final int maxCapacityMultiple;
    private final int minMaxCapacity;
    private final int maxMaxCapacityDifference;
    private final DirectBufferAllocator directBufferAllocater;
    private final int retryLogThreshold;
    private volatile int blockingCount = 0;
    private final Object blockLock = new Object();
    private final boolean trackAllocations;
    private final ConcurrentMap<Long, AllocCacheEntry> debugTrackMap;
    private final ReferenceQueue<ByteBuffer> garbageTrackingQueue;

    private static long bufferToCacheKey(ByteBuffer buff) {
        return buff == null ? Long.MIN_VALUE : ((DirectBuffer)((Object)buff)).address();
    }

    private static StringBuilder dumpEntry(AllocCacheEntry entry, long now, StringBuilder soFar) {
        long durationNanos = now - entry.allocTimestampNanos;
        ByteBuffer bb = (ByteBuffer)entry.reference.get();
        if (bb != null) {
            soFar.append("size = ").append(bb.capacity());
        } else {
            soFar.append("ByteBuffer GCed");
        }
        soFar.append(", time checked out for = ").append(TimeUnit.NANOSECONDS.toMillis(durationNanos)).append(" (ms)").append('\n');
        StringWriter stringWriter = new StringWriter();
        entry.stackTrace.printStackTrace(new PrintWriter(stringWriter));
        soFar.append(stringWriter.toString());
        return soFar;
    }

    ByteBufferPoolBase(PoolConfigurationBase<?> pc) {
        this.name = ((PoolConfigurationBase)pc).name;
        this.maxMemorySize = ((PoolConfigurationBase)pc).maxMemorySize;
        this.minMemorySize = ((PoolConfigurationBase)pc).minMemorySize;
        this.ageoutTimeMillis = ((PoolConfigurationBase)pc).timeoutMillis;
        this.ageoutCache = ExpiringInsertionMap.create((String)(this.name + " ageout cache"), (int)((PoolConfigurationBase)pc).maxCacheSize, (int)((PoolConfigurationBase)pc).maxCacheSize, (long)this.ageoutTimeMillis, (ExpiringMap.ExpirationListener)new ByteBufferExpirationListener());
        this.maxCapacityMultiple = ((PoolConfigurationBase)pc).maxCapacityMultiple;
        this.minMaxCapacity = ((PoolConfigurationBase)pc).minMaxCapacity;
        this.maxMaxCapacityDifference = ((PoolConfigurationBase)pc).maxMaxCapacityDifference;
        this.directBufferAllocater = ((PoolConfigurationBase)pc).directBufferAllocater;
        this.retryLogThreshold = ((PoolConfigurationBase)pc).retryLogThreshold;
        boolean bl = this.trackAllocations = ((PoolConfigurationBase)pc).trackAllocations || Boolean.getBoolean(DEBUG_TRACK_ALLOCATIONS);
        if (this.trackAllocations) {
            log.log(Level.WARNING, "{0}: byte buffer pool constructed with debug tracking enabled!", this.name);
            this.debugTrackMap = new ConcurrentHashMap<Long, AllocCacheEntry>();
            this.garbageTrackingQueue = new ReferenceQueue();
        } else {
            this.debugTrackMap = null;
            this.garbageTrackingQueue = null;
        }
    }

    public long allocated() {
        return this.currentAllocationSize.get();
    }

    public long checkedOut() {
        return this.currentCheckedOutSize.get();
    }

    public int pooledBuffersCount() {
        return this.availableSet.size();
    }

    public int getRetryLogThreshold() {
        return this.retryLogThreshold;
    }

    public String dumpTrackedBuffers(int limit) {
        return this.dumpTrackedBuffers(limit, -1);
    }

    public String dumpTrackedBuffers(int limit, int sizeFilter) {
        if (!this.trackAllocations) {
            return "allocation tracking not enabled, set -Dhds.byteBufferPool.trackAlloc=true to enable allocation tracking gloabally";
        }
        this.handleGarbage();
        ArrayList trackList = Lists.newArrayListWithExpectedSize((int)this.debugTrackMap.size());
        trackList.addAll(this.debugTrackMap.values());
        Collections.sort(trackList, ALLOC_CACHE_ENTRY_COMPARATOR);
        long now = System.nanoTime();
        int dumpCount = 0;
        Iterator iter = trackList.iterator();
        StringBuilder builder = new StringBuilder();
        while (dumpCount < limit && iter.hasNext()) {
            AllocCacheEntry ent = (AllocCacheEntry)iter.next();
            ByteBuffer bb = (ByteBuffer)ent.reference.get();
            if (bb != null && sizeFilter >= 0 && bb.capacity() != sizeFilter) continue;
            ByteBufferPoolBase.dumpEntry(ent, now, builder);
            ++dumpCount;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer allocateResource(int capacity, AllocationCallbacks callbacks, Exhaustion exhaustion) {
        int retry = 0;
        this.handleGarbage();
        NavigableSet<BufferWrapper> subSet = this.getSubSetMinimumCapacity(capacity);
        ByteBuffer buffer = this.tryAllocate(capacity, subSet, callbacks, retry);
        if (buffer == null) {
            if (exhaustion == Exhaustion.BLOCK) {
                Object object = this.blockLock;
                synchronized (object) {
                    if (this.blockingCount++ == 0) {
                        log.log(Level.FINE, "{0}: Blocking on request for buffer of size {1}", (Object)this.name, (long)capacity);
                    }
                    try {
                        boolean interrupted = false;
                        while ((buffer = this.tryAllocate(capacity, subSet, callbacks, ++retry)) == null) {
                            try {
                                this.blockLock.wait(BLOCK_TIMEOUT_MILLIS);
                            }
                            catch (InterruptedException ire) {
                                interrupted = true;
                            }
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        --this.blockingCount;
                    }
                }
            }
            if (exhaustion == Exhaustion.ALLOCATE_HEAP) {
                buffer = ByteBuffer.allocate(capacity);
            }
        }
        return this.trackIfNecessary(buffer);
    }

    @VisibleForTesting
    void clearPool() {
        this.availableSet.clear();
        this.ageoutCache.clear();
    }

    @VisibleForTesting
    ByteBuffer handleMaxReached(int capacity, NavigableSet<BufferWrapper> subSet, long reserved) {
        ByteBuffer buffer = null;
        if (this.currentAllocationSize.get() - this.currentCheckedOutSize.get() >= (long)capacity - reserved) {
            Map.Entry entry;
            while (buffer == null && reserved < (long)capacity && (entry = this.ageoutCache.forceExpire(false)) != null) {
                BufferWrapper wrapper = (BufferWrapper)entry.getKey();
                if (this.removeWrapperFromSet(wrapper)) {
                    reserved += (long)wrapper.capacity();
                    this.directBufferAllocater.deallocate(wrapper.getBuffer());
                }
                if (subSet == null) continue;
                buffer = this.checkoutBufferFromSubSet(subSet);
            }
        }
        long unreserve = reserved;
        if (buffer == null && reserved >= (long)capacity) {
            buffer = this.allocateWithSpaceReserved(capacity);
            unreserve = reserved - (long)capacity;
        }
        if (unreserve > 0L) {
            this.currentAllocationSize.getAndAdd(-unreserve);
        }
        return buffer;
    }

    void returnResource(ByteBuffer resource, Function<ByteBuffer, Void> onReturn) {
        this.handleGarbage();
        if (this.rejectBuffer(resource)) {
            return;
        }
        BufferWrapper wrapper = new BufferWrapper(resource);
        this.removeFromTrackerIfNecessary(resource);
        if (this.returnResource(wrapper)) {
            if (onReturn != null) {
                onReturn.apply((Object)resource);
            }
            this.notifyBlockers();
        }
    }

    @VisibleForTesting
    NavigableSet<BufferWrapper> subSet(int minCapacity, int maxCapacity) {
        return this.availableSet.subSet((Object)new SearchKey(minCapacity), (Object)new SearchKey(maxCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBlockers() {
        if (this.blockingCount > 0) {
            Object object = this.blockLock;
            synchronized (object) {
                this.blockLock.notifyAll();
            }
        }
    }

    private void addBufferToTrackingCache(ByteBuffer buff) {
        AllocCacheEntry entry = new AllocCacheEntry(buff);
        this.debugTrackMap.put(entry.key(), entry);
    }

    private boolean addToAgeoutCache(BufferWrapper wrapper) {
        return this.ageoutCache.putIfAbsent((Object)wrapper, (Object)wrapper) == null;
    }

    private void addWrapperToSet(BufferWrapper wrapper) {
        this.availableSet.add(wrapper);
    }

    private ByteBuffer allocateNewBuffer(int capacity, NavigableSet<BufferWrapper> subSet) {
        long currentAlloc;
        long reserved;
        while ((reserved = Math.min(this.maxMemorySize - (currentAlloc = this.currentAllocationSize.get()), (long)capacity)) > 0L && !this.currentAllocationSize.compareAndSet(currentAlloc, currentAlloc + reserved)) {
        }
        ByteBuffer buffer = reserved == (long)capacity ? this.allocateWithSpaceReserved(capacity) : this.handleMaxReached(capacity, subSet, reserved);
        return buffer;
    }

    private ByteBuffer allocateWithSpaceReserved(int capacity) {
        ByteBuffer directBuffer = this.directBufferAllocater.allocate(capacity);
        if (directBuffer == null) {
            this.currentAllocationSize.getAndAdd(-capacity);
            return null;
        }
        this.increaseCheckedOutMemoryUsage(directBuffer);
        return directBuffer;
    }

    private ByteBuffer checkoutBufferFromSubSet(NavigableSet<BufferWrapper> subSet) {
        BufferWrapper wrap = subSet.pollFirst();
        if (wrap != null) {
            this.removeFromAgeoutCache(wrap);
            ByteBuffer buffer = wrap.getBuffer();
            this.increaseCheckedOutMemoryUsage(buffer);
            return buffer;
        }
        return null;
    }

    private void decreaseCheckedOutMemory(ByteBuffer checkedOutBuffer) {
        this.currentCheckedOutSize.getAndAdd(-checkedOutBuffer.capacity());
    }

    private void increaseCheckedOutMemoryUsage(ByteBuffer checkedOutBuffer) {
        this.currentCheckedOutSize.getAndAdd(checkedOutBuffer.capacity());
    }

    private NavigableSet<BufferWrapper> getSubSetMinimumCapacity(int capacity) {
        int maxCapacity = Math.max(capacity * this.maxCapacityMultiple, this.minMaxCapacity);
        maxCapacity = Math.min(maxCapacity, capacity + this.maxMaxCapacityDifference) + 1;
        return this.subSet(capacity, maxCapacity);
    }

    private void handleGarbage() {
        if (this.trackAllocations) {
            Reference<ByteBuffer> ref;
            while ((ref = this.garbageTrackingQueue.poll()) != null) {
                AllocCacheEntry entry = (AllocCacheEntry)this.debugTrackMap.remove(((BufferReference)ref).key);
                if (entry == null) continue;
                log.log(Level.SEVERE, "{0}: Buffer leaked! Checked out for {1}ns", (Throwable)entry.stackTrace, (Object)this.name, System.nanoTime() - entry.allocTimestampNanos);
            }
        }
    }

    private boolean rejectBuffer(ByteBuffer resource) {
        if (!resource.isDirect()) {
            return true;
        }
        DirectBuffer db = (DirectBuffer)((Object)resource);
        if (db.attachment() != null && db.attachment() instanceof DirectBuffer) {
            log.log(Level.SEVERE, "{0}: {1} appears to be a slice or copy of {2}", (Throwable)new RuntimeException(), (Object)this.name, (Object)db, db.attachment());
            return true;
        }
        return false;
    }

    private boolean removeFromAgeoutCache(BufferWrapper wrapper) {
        return this.ageoutCache.remove((Object)wrapper) != null;
    }

    private void removeFromTrackerIfNecessary(ByteBuffer buff) {
        if (this.trackAllocations) {
            this.debugTrackMap.remove(ByteBufferPoolBase.bufferToCacheKey(buff));
        }
    }

    private boolean removeWrapperFromSet(BufferWrapper wrapper) {
        return this.availableSet.remove(wrapper);
    }

    private boolean returnResource(BufferWrapper buffer) {
        if (!this.addToAgeoutCache(buffer)) {
            log.log(Level.SEVERE, "{0}: Same buffer added twice", (Throwable)new RuntimeException(), (Object)this.name);
            return false;
        }
        this.decreaseCheckedOutMemory(buffer.getBuffer());
        buffer.doClean();
        this.addWrapperToSet(buffer);
        return true;
    }

    private ByteBuffer trackIfNecessary(ByteBuffer bufferToTrack) {
        if (this.trackAllocations && bufferToTrack != null && bufferToTrack.isDirect()) {
            this.addBufferToTrackingCache(bufferToTrack);
        }
        return bufferToTrack;
    }

    private ByteBuffer tryAllocate(int capacity, NavigableSet<BufferWrapper> subSet, AllocationCallbacks callbacks, int retry) {
        ByteBuffer buffer = null;
        if (callbacks.preAllocation(capacity)) {
            try {
                buffer = this.checkoutBufferFromSubSet(subSet);
                if (buffer != null && !callbacks.postAllocation(capacity, buffer)) {
                    this.returnResource(buffer, null);
                    buffer = null;
                    subSet = null;
                }
                if (buffer == null) {
                    buffer = this.allocateNewBuffer(capacity, subSet);
                    buffer = this.postAllocate(buffer, capacity, callbacks, false);
                }
            }
            catch (Throwable t) {
                this.postAllocate(buffer, capacity, callbacks, true);
                throw t;
            }
        }
        if (buffer == null) {
            callbacks.exhausted(capacity, retry);
        }
        return buffer;
    }

    private ByteBuffer postAllocate(ByteBuffer buffer, final int requestedCapacity, final AllocationCallbacks callbacks, boolean failed) {
        if (buffer == null) {
            callbacks.allocationFailure(requestedCapacity);
            this.notifyBlockers();
        } else if (failed || !callbacks.postAllocation(requestedCapacity, buffer)) {
            this.returnResource(buffer, new Function<ByteBuffer, Void>(){

                public Void apply(ByteBuffer input) {
                    callbacks.allocationFailure(requestedCapacity);
                    return null;
                }
            });
            buffer = null;
        }
        return buffer;
    }

    static /* synthetic */ DirectBufferAllocator access$1200() {
        return DEFAULT_ALLOCATER;
    }

    private class BufferReference
    extends WeakReference<ByteBuffer> {
        final Long key;

        public BufferReference(ByteBuffer referent) {
            super(referent, ByteBufferPoolBase.this.garbageTrackingQueue);
            this.key = ByteBufferPoolBase.bufferToCacheKey(referent);
        }
    }

    private final class AllocCacheEntry {
        final BufferReference reference;
        final Exception stackTrace;
        final long allocTimestampNanos;

        public AllocCacheEntry(ByteBuffer buff) {
            this.reference = new BufferReference(buff);
            this.stackTrace = new Exception();
            this.allocTimestampNanos = System.nanoTime();
        }

        public Long key() {
            return this.reference.key;
        }
    }

    private static final class SearchKey
    extends BufferWrapper {
        private final int capacity;

        public SearchKey(int capacity) {
            super(null);
            this.capacity = capacity;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }
    }

    private final class ByteBufferExpirationListener
    implements ExpiringMap.ExpirationListener<BufferWrapper, BufferWrapper> {
        private ByteBufferExpirationListener() {
        }

        public void entryExpired(BufferWrapper buffer, BufferWrapper value, boolean forced) {
            if (!ByteBufferPoolBase.this.removeWrapperFromSet(buffer)) {
                return;
            }
            long newSize = ByteBufferPoolBase.this.currentAllocationSize.addAndGet(-value.capacity());
            if (!forced && newSize < ByteBufferPoolBase.this.minMemorySize) {
                if (ByteBufferPoolBase.this.addToAgeoutCache(buffer)) {
                    ByteBufferPoolBase.this.addWrapperToSet(buffer);
                    ByteBufferPoolBase.this.currentAllocationSize.addAndGet(buffer.capacity());
                }
            } else {
                ByteBufferPoolBase.this.directBufferAllocater.deallocate(buffer.getBuffer());
            }
        }
    }

    static class BufferWrapper
    implements Comparable<BufferWrapper> {
        public final ByteBuffer buffer;

        public BufferWrapper(ByteBuffer buff) {
            this.buffer = buff;
        }

        public int capacity() {
            return this.buffer.capacity();
        }

        @Override
        public int compareTo(BufferWrapper o) {
            int result = Integer.compare(this.capacity(), o.capacity());
            if (result == 0) {
                result = Long.compare(ByteBufferPoolBase.bufferToCacheKey(this.buffer), ByteBufferPoolBase.bufferToCacheKey(o.buffer));
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BufferWrapper) {
                return this.buffer == ((BufferWrapper)obj).buffer;
            }
            return false;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int hashCode() {
            return System.identityHashCode(this.buffer);
        }

        protected void doClean() {
            this.buffer.clear();
        }
    }

    public static enum Exhaustion {
        NONE,
        BLOCK,
        ALLOCATE_HEAP;

    }

    static interface AllocationCallbacks {
        public boolean preAllocation(int var1);

        public boolean postAllocation(int var1, ByteBuffer var2);

        public void allocationFailure(int var1);

        public void exhausted(int var1, int var2);
    }

    static abstract class PoolConfigurationBase<T extends PoolConfigurationBase<T>> {
        private static final AtomicInteger count = new AtomicInteger();
        private final long maxMemorySize;
        private final long minMemorySize;
        private long timeoutMillis = TimeUnit.MINUTES.toMillis(5L);
        private int maxCacheSize;
        private boolean trackAllocations = false;
        private int maxCapacityMultiple = 2;
        private int minMaxCapacity = 4096;
        private int maxMaxCapacityDifference = (int)StorageUnit.MB.toB(1.0);
        private int retryLogThreshold = 32;
        private DirectBufferAllocator directBufferAllocater = ByteBufferPoolBase.access$1200();
        private String name = "ByteBufferPool-" + count.incrementAndGet();

        PoolConfigurationBase(long maxMemorySize, long minMemorySize) {
            this.maxMemorySize = maxMemorySize;
            this.minMemorySize = minMemorySize;
            this.maxCacheSize = (int)(maxMemorySize / StorageUnit.KB.toB(16.0));
        }

        public T directBufferAllocator(DirectBufferAllocator directBufferAllocater) {
            this.directBufferAllocater = directBufferAllocater;
            return this.instance();
        }

        public T maxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this.instance();
        }

        public T maxCapacityMultiple(int maxCapacityMultiple) {
            this.maxCapacityMultiple = maxCapacityMultiple;
            return this.instance();
        }

        public T maxMaxCapacityDifference(int maxMaxCapacityDifference) {
            this.maxMaxCapacityDifference = maxMaxCapacityDifference;
            return this.instance();
        }

        public T minMaxCapacity(int minMaxCapacity) {
            this.minMaxCapacity = minMaxCapacity;
            return this.instance();
        }

        public T name(String name) {
            this.name = name;
            return this.instance();
        }

        public T timeout(long time, TimeUnit unit) {
            this.timeoutMillis = unit.toMillis(time);
            return this.instance();
        }

        public T timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this.instance();
        }

        public T trackAllocations(boolean trackAllocations) {
            this.trackAllocations = trackAllocations;
            return this.instance();
        }

        public T logExhaustionOnRetries(int retries) {
            this.retryLogThreshold = retries;
            return this.instance();
        }

        abstract T instance();
    }
}

