/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.StringTokenizer;

public class CharEscaper {
    private static final String ESCAPE_CHAR_STR = "\\";
    private final String charsToEscape;

    private CharEscaper(String charsToEscape) {
        this.charsToEscape = charsToEscape;
    }

    public String escape(String str) {
        if (this.charsToEscape.isEmpty() || Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer t = new StringTokenizer(str, this.charsToEscape, true);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (this.charsToEscape.contains(token)) {
                sb.append(ESCAPE_CHAR_STR);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static CharEscaper on(String charsToEscape) {
        Preconditions.checkNotNull((Object)charsToEscape);
        return new CharEscaper(charsToEscape);
    }

    public static CharEscaper on(char charToEscape) {
        return CharEscaper.on(String.valueOf(charToEscape));
    }

    public static CharEscaper on(char[] charsToEscape) {
        Preconditions.checkNotNull((Object)charsToEscape);
        return CharEscaper.on(String.valueOf(charsToEscape));
    }

    public static CharEscaper on(CharSequence charsToEscape) {
        Preconditions.checkNotNull((Object)charsToEscape);
        return CharEscaper.on(charsToEscape.toString());
    }
}

