/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hds.commons.exception.InvalidEnumException;
import com.hds.commons.strings.Splitters;
import com.hds.commons.util.EnumHashId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EnumHelper {
    private static final Splitter CSV_SPLITTER = Splitters.csv();

    public static <E extends Enum<E>> E checkedValueOf(Class<E> enumType, String name) throws InvalidEnumException {
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEnumException("Not a valid enum name " + name + " for type " + enumType, e);
        }
    }

    public static List<String> enumSetToStrings(EnumSet<?> enums) {
        ArrayList retList = Lists.newArrayListWithCapacity((int)enums.size());
        for (Enum en : enums) {
            retList.add(en.toString());
        }
        return retList;
    }

    public static <E extends Enum<E>> EnumSet<E> csvToEnum(Class<E> enumType, String csv) throws InvalidEnumException {
        EnumSet<E> set = EnumSet.noneOf(enumType);
        for (String s : CSV_SPLITTER.split((CharSequence)csv)) {
            set.add(EnumHelper.checkedValueOf(enumType, s));
        }
        return set;
    }

    public static <E extends Enum<E>, V> Map<E, V> mapTo(Class<E> enumType, Function<E, V> valueMethod) {
        EnumMap map = Maps.newEnumMap(enumType);
        for (Enum key : EnumSet.allOf(enumType)) {
            Object value = valueMethod.apply((Object)key);
            map.put(key, value);
        }
        return map;
    }

    public static int enumHashCode(Set<? extends EnumHashId> values) {
        int h = 0;
        for (EnumHashId enumHashId : values) {
            if (enumHashId == null) continue;
            h += enumHashId.getId();
        }
        return h;
    }
}

