/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.hds.commons.json.IgnoreExclusion;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;

public class GsonHelper {
    private static final Gson GSON;
    public static final Gson GSON_PRETTY;

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static String toJson(Object src, Class<?> classOfT) {
        return GSON.toJson(src, classOfT);
    }

    public static void toJson(Object src, Appendable writer) {
        GSON.toJson(src, writer);
    }

    public static void toJson(Object src, Type typeOfClass, JsonWriter writer) {
        GSON.toJson(src, typeOfClass, writer);
    }

    public static String toPrettyJson(Object src) {
        return GSON_PRETTY.toJson(src);
    }

    public static String toPrettyJson(Object src, Class<?> classOfT) {
        return GSON_PRETTY.toJson(src, classOfT);
    }

    public static void toPrettyJson(Object src, Appendable writer) {
        GSON_PRETTY.toJson(src, writer);
    }

    public static void toPrettyJson(Object src, Type typeOfClass, JsonWriter writer) {
        GSON_PRETTY.toJson(src, typeOfClass, writer);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfClass) {
        return (T)GSON.fromJson(json, typeOfClass);
    }

    public static <T> T fromJson(InputStream json, Type typeOfClass) {
        return GsonHelper.fromJson((Reader)new InputStreamReader(json), typeOfClass);
    }

    public static <T> T fromJson(Reader json, Class<T> classOfT) {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(Reader json, Type typeOfClass) {
        return (T)GSON.fromJson(json, typeOfClass);
    }

    public static <T> T fromJson(JsonElement json, Type typeOfClass) {
        return (T)GSON.fromJson(json, typeOfClass);
    }

    static {
        IgnoreExclusion es = new IgnoreExclusion();
        GsonBuilder gb = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{es});
        GSON = gb.create();
        GSON_PRETTY = gb.setPrettyPrinting().disableHtmlEscaping().create();
    }
}

