/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Splitter;
import gnu.inet.encoding.IDNA;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class LdapUtil {
    private static final String HOSTNAME_FORMAT = "(\\p{Alnum}|-)+";
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("(\\p{Alnum}|-)+");
    public static final String DOMAIN_SEPARATOR_COMMA = ",DC=";
    public static final String DOMAIN_SEPARATOR = "DC=";
    private static final char ENTRY_SEPARATOR = ',';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final String ESCAPE_CHAR_STR = "\\";

    public static String normalizeDistinguishedName(String distinguishedName) {
        if (distinguishedName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(distinguishedName.length());
        Iterator entryIter = COMMA_SPLITTER.split((CharSequence)distinguishedName).iterator();
        while (entryIter.hasNext()) {
            String entry = (String)entryIter.next();
            Iterator splitEntry = EQUAL_SPLITTER.split((CharSequence)entry).iterator();
            sb.append(((String)splitEntry.next()).toUpperCase());
            if (splitEntry.hasNext()) {
                sb.append('=').append((String)splitEntry.next());
            }
            if (!entryIter.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static String fromDnToFqdn(String distinguishedName) {
        String domain = null;
        if (distinguishedName != null) {
            int index = 0;
            if (distinguishedName.startsWith(DOMAIN_SEPARATOR)) {
                index = DOMAIN_SEPARATOR.length();
                domain = distinguishedName.substring(index).replaceAll(DOMAIN_SEPARATOR_COMMA, "\\.");
            } else {
                index = distinguishedName.indexOf(DOMAIN_SEPARATOR_COMMA);
                if (index >= 0) {
                    domain = distinguishedName.substring(index + DOMAIN_SEPARATOR_COMMA.length()).replaceAll(DOMAIN_SEPARATOR_COMMA, "\\.");
                }
            }
        }
        return domain != null ? domain.toUpperCase() : null;
    }

    public static String fromFqdnToDn(String fqdn) {
        if (fqdn == null) {
            return null;
        }
        fqdn = DOMAIN_SEPARATOR + fqdn.replaceAll("\\.", DOMAIN_SEPARATOR_COMMA);
        return fqdn;
    }

    public static String stripDomainComponents(String distinguishedName) {
        if (distinguishedName == null) {
            return null;
        }
        int index = distinguishedName.indexOf(DOMAIN_SEPARATOR);
        if (index > 0 && distinguishedName.charAt(index - 1) == ',') {
            --index;
        }
        if (index > -1) {
            return distinguishedName.substring(0, index);
        }
        return distinguishedName;
    }

    public static String createDn(String name, String fqdn) {
        return name + ',' + LdapUtil.fromFqdnToDn(fqdn);
    }

    public static void validateADServiceUser(String name) throws InvalidHostnameException {
        LdapUtil.validateHostname(name);
        Pattern validateOnAlphaPattern = Pattern.compile(".*(\\p{Alpha}|-|\\.).*");
        if (!validateOnAlphaPattern.matcher(name).matches()) {
            throw new InvalidHostnameException("AD service user name \"" + name + "\" contains all digits");
        }
    }

    public static void validateHostname(String hostname) throws InvalidHostnameException {
        try {
            String asciiName = IDNA.toASCII((String)hostname);
            if (!HOSTNAME_PATTERN.matcher(asciiName).matches()) {
                throw new InvalidHostnameException("hostname \"" + hostname + "\" contains invalid characters");
            }
            if (asciiName.charAt(0) == '-' || asciiName.charAt(asciiName.length() - 1) == '-') {
                throw new InvalidHostnameException("hostname \"" + hostname + "\" starts or begins with a hyphen");
            }
        }
        catch (Exception ex) {
            throw new InvalidHostnameException("Invalid hostname \"" + hostname + "\"", ex);
        }
    }

    public static String escapeValue(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer t = new StringTokenizer(str, ESCAPE_CHAR_STR, true);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            sb.append(token);
            if (!ESCAPE_CHAR_STR.equals(token)) continue;
            sb.append(ESCAPE_CHAR_STR);
        }
        return "\"" + sb.toString() + "\"";
    }

    public static class InvalidHostnameException
    extends Exception {
        public InvalidHostnameException(String message) {
            super(message);
        }

        public InvalidHostnameException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

