/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.util.Pool;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LimitedPool<T>
extends Pool<T> {
    private static final Logger defaultLog = Logger.getLogger(LimitedPool.class.getName());
    protected int created;
    protected final boolean quiet;

    protected LimitedPool(int maxSize, int initialSize, String name) {
        this(maxSize, initialSize, name, false, defaultLog);
    }

    protected LimitedPool(int maxSize, int initialSize, String name, boolean quiet) {
        this(maxSize, initialSize, name, quiet, defaultLog);
    }

    protected LimitedPool(int maxSize, int initialSize, String name, boolean quiet, Logger log) {
        super(maxSize, initialSize, name, log);
        this.quiet = quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T getOrMake() {
        Object object = this.getLock();
        synchronized (object) {
            while (this.isAtEmptyLimit()) {
                if (this.emptyLimitAction()) continue;
                return null;
            }
            return super.getOrMake();
        }
    }

    protected boolean isAtEmptyLimit() {
        return this.isEmpty() && this.isFullyAllocated();
    }

    protected boolean emptyLimitAction() {
        if (!this.quiet) {
            defaultLog.log(Level.WARNING, "Waiting on pooled resource {0}", this);
        }
        this.block();
        if (!this.quiet) {
            defaultLog.log(Level.WARNING, "Done waiting on pooled resource {0}", this);
        }
        return true;
    }

    @Override
    protected T callAllocate() {
        Object create = super.callAllocate();
        if (create != null) {
            ++this.created;
        }
        return create;
    }

    protected boolean isFullyAllocated() {
        return this.created == this.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(T resource) {
        Object object = this.getLock();
        synchronized (object) {
            boolean returned = super.put(resource);
            if (returned) {
                this.unblock();
            }
            return returned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object pooled) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean removed = super.remove(pooled);
            if (removed) {
                this.decrement();
                lock.notify();
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean free(Object pooled) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean removed = super.remove(pooled);
            this.decrement();
            lock.notify();
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFreed() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.decrement();
            lock.notify();
        }
    }

    protected void decrement() {
        --this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblock() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void block() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                if (!this.quiet) {
                    defaultLog.log(Level.SEVERE, "Interrupted while waiting for pooled resource");
                }
                System.out.println("Interrupted while quiet and waiting for pooled resource");
            }
        }
    }
}

