/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.util.SimpleWorkQueue;
import com.hds.commons.util.Thunk;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LimitedWorkQueue
extends SimpleWorkQueue {
    private static final Logger defaultlog = Logger.getLogger(LimitedWorkQueue.class.getName());
    protected final int highwater;
    protected final int lowwater;

    public LimitedWorkQueue(String name, int highwater, ThreadGroup threadGroup) {
        this(name, highwater, highwater - 1, threadGroup);
    }

    public LimitedWorkQueue(String name, int highwater, int lowwater, ThreadGroup threadGroup) {
        super(name, defaultlog, threadGroup);
        this.highwater = highwater;
        this.lowwater = lowwater;
        assert (highwater > lowwater) : " highwater " + highwater + " lowwater " + lowwater;
    }

    public LimitedWorkQueue(String name, int count, int highwater, int lowwater, ThreadGroup threadGroup) {
        super(name, count, defaultlog, threadGroup);
        this.highwater = highwater;
        this.lowwater = lowwater;
    }

    public LimitedWorkQueue(String name, int count, int highwater, int lowwater, Logger log, ThreadGroup threadGroup) {
        super(name, count, log, threadGroup);
        this.highwater = highwater;
        this.lowwater = lowwater;
    }

    @Override
    public boolean enqueue(Thunk work) {
        while (this.checkStatus()) {
            if (this.atHighwater()) {
                if (!this.reject()) continue;
                return false;
            }
            return this.actuallyEnqueue(work);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean atHighwater() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            int availWorkers = this.unitializedWorkers() + this.getWorkersOnBreak();
            return this.started && this.queue.size() - availWorkers >= this.highwater;
        }
    }

    protected boolean reject() {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, "Rejecting since backlog of {0} is too high for queue {1}", new Object[]{this.queue.size(), this.getName()});
        }
        return true;
    }
}

