/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.util.logging.RISLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class PerformanceTracker {
    private static final RISLogger log = RISLogger.getLogger();
    public static final int MAXIMUM_LOCAL_MAP_UPDATES = 100;
    protected static final long PROCESSING_PERIOD_MS = 2000L;
    protected static final double TICKS_PER_MILLI = 1000000.0;
    protected static final DummyTimeCounter dummyCounter = new DummyTimeCounter();
    protected volatile boolean gatherStatistics = false;
    protected volatile Set<? extends Category> gatherStatisticsCategories;
    protected volatile int samplingPeriod = 0;
    protected Queue<Collection<PerformanceStatistics>> processingQueue = new ConcurrentLinkedQueue<Collection<PerformanceStatistics>>();
    protected Map<String, PerformanceStatistics> statisticsMap = new HashMap<String, PerformanceStatistics>();
    protected final ScheduledExecutorService periodicExecutor = Executors.newScheduledThreadPool(1);
    protected ScheduledFuture<?> processingThread = null;
    protected ThreadLocal<Map<String, PerformanceStatistics>> localStatMap = new ThreadLocal<Map<String, PerformanceStatistics>>(){

        @Override
        protected Map<String, PerformanceStatistics> initialValue() {
            return null;
        }
    };
    protected ThreadLocal<Integer> localStatUpdateCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return PerformanceTracker.this.ZERO;
        }
    };
    protected final Integer ZERO = 0;
    protected final NoCounterPerformanceCounter DUMMY_COUNTER = new NoCounterPerformanceCounter("DISABLED");

    public PerformanceTracker(boolean enabled, int samplingPeriod, Set<? extends Category> categories) {
        this.setEnabled(enabled, categories);
        this.setSamplingPeriod(samplingPeriod);
    }

    public boolean enabled(Category category) {
        if (!this.gatherStatistics) {
            return false;
        }
        return this.gatherStatisticsCategories.isEmpty() || this.gatherStatisticsCategories.contains(category);
    }

    public PerformanceStatistics getStatistics(String name, Category category) {
        if (!this.enabled(category)) {
            return this.DUMMY_COUNTER;
        }
        Map<String, PerformanceStatistics> localMap = this.localStatMap.get();
        if (localMap == null) {
            localMap = this.buildThreadLocalMap();
            this.localStatMap.set(localMap);
            this.localStatUpdateCount.set(0);
        }
        if (localMap.containsKey(name)) {
            return localMap.get(name);
        }
        PerformanceStatistics stats = this.getCounterImpl(name);
        localMap.put(name, stats);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PerformanceStatistics> getAllStatistics() {
        TreeMap<String, PerformanceStatistics> snapshot = new TreeMap<String, PerformanceStatistics>();
        Map<String, PerformanceStatistics> map = this.statisticsMap;
        synchronized (map) {
            snapshot.putAll(this.statisticsMap);
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PerformanceStatistics> resetStatistics() {
        HashMap<String, PerformanceStatistics> oldMap = new HashMap<String, PerformanceStatistics>();
        Map<String, PerformanceStatistics> map = this.statisticsMap;
        synchronized (map) {
            oldMap.putAll(this.statisticsMap);
            this.statisticsMap.clear();
        }
        return oldMap;
    }

    public void setEnabled(boolean enabled, Set<? extends Category> categories) {
        boolean oldVal = this.gatherStatistics;
        this.gatherStatistics = enabled;
        HashSet<? extends Category> hashSet = this.gatherStatisticsCategories = categories == null ? Collections.emptySet() : new HashSet<Category>(categories);
        if (this.gatherStatistics && !oldVal) {
            this.resetStatistics();
            this.initProcessingThread();
        }
        log.log(Level.INFO, "statistics gathering is {0}", this.gatherStatistics ? "on" : "off");
    }

    public void setSamplingPeriod(int samplingPeriod) {
        int oldVal = this.samplingPeriod;
        this.samplingPeriod = samplingPeriod;
        if (oldVal <= 0 && samplingPeriod > 0) {
            this.resetStatistics();
            this.initProcessingThread();
        }
        log.log(Level.INFO, "sampling period is {0}", samplingPeriod);
    }

    void updateStatsIfNecessary() {
        if (!this.gatherStatistics) {
            return;
        }
        int updateCount = this.localStatUpdateCount.get();
        this.localStatUpdateCount.set(updateCount + 1);
        if (updateCount >= 100) {
            this.processStatisticsMap(this.localStatMap.get());
        }
    }

    Map<String, PerformanceStatistics> buildThreadLocalMap() {
        return new HashMap<String, PerformanceStatistics>();
    }

    public synchronized void initProcessingThread() {
        if (this.processingThread != null) {
            return;
        }
        Runnable processingRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PerformanceTracker.this.processEntireQueue();
                }
                catch (Throwable th) {
                    log.log(Level.WARNING, "Statistics processing thread encountered an error!", th);
                }
            }
        };
        this.processingThread = this.periodicExecutor.scheduleAtFixedRate(processingRunnable, 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    protected PerformanceStatistics getCounterImpl(String name) {
        if (this.gatherStatistics) {
            if (this.samplingPeriod > 0) {
                return new PeriodicSamplingAvgMinMaxPerformanceCounter(name, this.samplingPeriod);
            }
            return new AlwaysSamplingAvgMinMaxPerformanceCounter(name);
        }
        return new NoCounterPerformanceCounter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEntireQueue() throws Exception {
        Collection<PerformanceStatistics> currentStatistics = this.processingQueue.poll();
        Map<String, PerformanceStatistics> map = this.statisticsMap;
        synchronized (map) {
            while (currentStatistics != null) {
                for (PerformanceStatistics stats : currentStatistics) {
                    this.processUpdate(stats.name, stats);
                }
                currentStatistics = this.processingQueue.poll();
            }
        }
    }

    protected void processStatisticsMap(Map<String, PerformanceStatistics> statMap) {
        if (statMap == null) {
            return;
        }
        if (this.addToProcessingQueue(statMap.values())) {
            this.localStatMap.remove();
            this.localStatUpdateCount.remove();
        } else {
            log.log(Level.WARNING, "Unable to add statistics to processing queue!");
        }
    }

    protected boolean addToProcessingQueue(Collection<PerformanceStatistics> cachedStats) {
        boolean successful = this.processingQueue.offer(cachedStats);
        return successful;
    }

    protected void processUpdate(String key, PerformanceStatistics statEntry) {
        PerformanceStatistics old = this.statisticsMap.get(key);
        PerformanceStatistics combined = old == null ? statEntry : old.combine(statEntry);
        this.statisticsMap.put(key, combined);
    }

    protected class PeriodicSamplingAvgMinMaxPerformanceCounter
    extends AlwaysSamplingAvgMinMaxPerformanceCounter {
        protected int period;
        protected AtomicInteger sampleCount;
        protected DummyTimeCounter dummyCounter;

        public PeriodicSamplingAvgMinMaxPerformanceCounter(String name, int samplingPeriod) {
            super(name);
            this.period = samplingPeriod;
            this.sampleCount = new AtomicInteger(0);
            this.dummyCounter = new DummyTimeCounter();
        }

        @Override
        public TimeCounter start() {
            int oldVal = this.sampleCount.addAndGet(1);
            if (oldVal < this.period) {
                return this.dummyCounter;
            }
            if (this.sampleCount.compareAndSet(oldVal, oldVal - this.period)) {
                return new AlwaysSamplingAvgMinMaxPerformanceCounter.MaxMinTimeCounter();
            }
            return this.dummyCounter;
        }
    }

    public class AlwaysSamplingAvgMinMaxPerformanceCounter
    extends PerformanceStatistics {
        protected double minTime;

        @Override
        public String toString() {
            return "{ 'instanceName' : '" + this.name + "', 'values' : {'count' : " + this.count + ", 'average' : " + this.averageTimeMSec() + ", 'max' : " + this.maxTimeMSec() + ", 'min' : " + this.minTimeMSec() + ", 'units' : 'ms'}}";
        }

        private AlwaysSamplingAvgMinMaxPerformanceCounter(String name) {
            super(name);
            this.name = name;
            this.minTime = Double.MAX_VALUE;
        }

        @Override
        public TimeCounter start() {
            return new MaxMinTimeCounter();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public synchronized double averageTimeMSec() {
            return this.totalTime / (double)this.count / 1000000.0;
        }

        @Override
        public synchronized double maxTimeMSec() {
            return this.maxTime / 1000000.0;
        }

        @Override
        protected PerformanceStatistics combineAdditional(PerformanceStatistics combinedStats, PerformanceStatistics newStats) {
            if (combinedStats instanceof AlwaysSamplingAvgMinMaxPerformanceCounter && newStats instanceof AlwaysSamplingAvgMinMaxPerformanceCounter) {
                AlwaysSamplingAvgMinMaxPerformanceCounter minCombined = (AlwaysSamplingAvgMinMaxPerformanceCounter)combinedStats;
                AlwaysSamplingAvgMinMaxPerformanceCounter minNew = (AlwaysSamplingAvgMinMaxPerformanceCounter)newStats;
                minCombined.minTime = Math.min(this.minTime, minNew.minTime);
            }
            return combinedStats;
        }

        public synchronized double minTimeMSec() {
            return this.minTime / 1000000.0;
        }

        protected class MaxMinTimeCounter
        extends PerformanceStatistics.BasicTimeCounter {
            @Override
            public void stop() {
                long stopTime = System.nanoTime();
                double myTime = stopTime - this.start;
                ++AlwaysSamplingAvgMinMaxPerformanceCounter.this.count;
                AlwaysSamplingAvgMinMaxPerformanceCounter.this.totalTime += myTime;
                AlwaysSamplingAvgMinMaxPerformanceCounter.this.maxTime = Math.max(AlwaysSamplingAvgMinMaxPerformanceCounter.this.maxTime, myTime);
                AlwaysSamplingAvgMinMaxPerformanceCounter.this.minTime = Math.min(AlwaysSamplingAvgMinMaxPerformanceCounter.this.minTime, myTime);
                PerformanceTracker.this.updateStatsIfNecessary();
            }
        }
    }

    protected class NoCounterPerformanceCounter
    extends PerformanceStatistics {
        protected NoCounterPerformanceCounter(String name) {
            super(name);
        }

        @Override
        public String toString() {
            return this.name + "performance statistics disabled";
        }

        @Override
        public TimeCounter start() {
            return dummyCounter;
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public double averageTimeMSec() {
            return 0.0;
        }

        @Override
        public double maxTimeMSec() {
            return 0.0;
        }

        @Override
        protected PerformanceStatistics combineAdditional(PerformanceStatistics combinedStats, PerformanceStatistics newStats) {
            return combinedStats;
        }
    }

    public class AlwaysSamplingPerformanceCounter
    extends PerformanceStatistics {
        @Override
        public String toString() {
            return this.name + " {'count' : " + this.count + ", 'average': " + this.averageTimeMSec() + "ms, 'max': " + this.maxTimeMSec() + "ms}";
        }

        private AlwaysSamplingPerformanceCounter(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public TimeCounter start() {
            return new PerformanceStatistics.BasicTimeCounter();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public synchronized double averageTimeMSec() {
            return this.totalTime / (double)this.count / 1000000.0;
        }

        @Override
        public synchronized double maxTimeMSec() {
            return this.maxTime / 1000000.0;
        }

        @Override
        protected PerformanceStatistics combineAdditional(PerformanceStatistics combinedStats, PerformanceStatistics newStats) {
            return combinedStats;
        }
    }

    public abstract class PerformanceStatistics {
        protected String name;
        protected long count = 0L;
        protected double totalTime = 0.0;
        protected double maxTime = 0.0;

        protected PerformanceStatistics(String name) {
            this.name = name;
        }

        public abstract String toString();

        public abstract TimeCounter start();

        public abstract long count();

        public abstract double averageTimeMSec();

        public abstract double maxTimeMSec();

        protected abstract PerformanceStatistics combineAdditional(PerformanceStatistics var1, PerformanceStatistics var2);

        protected PerformanceStatistics combine(PerformanceStatistics newStats) {
            PerformanceStatistics combined = PerformanceTracker.this.getCounterImpl(newStats.name);
            combined.count = this.count + newStats.count;
            combined.totalTime = this.totalTime + newStats.totalTime;
            combined.maxTime = Math.max(this.maxTime, newStats.maxTime);
            return this.combineAdditional(combined, newStats);
        }

        public class BasicTimeCounter
        implements TimeCounter {
            long start;

            public BasicTimeCounter() {
                this.start = System.nanoTime();
            }

            protected BasicTimeCounter(long startTime) {
                this.start = startTime;
            }

            @Override
            public void stop() {
                long stopTime = System.nanoTime();
                double myTime = stopTime - this.start;
                ++PerformanceStatistics.this.count;
                PerformanceStatistics.this.totalTime += myTime;
                PerformanceStatistics.this.maxTime = Math.max(PerformanceStatistics.this.maxTime, myTime);
                PerformanceTracker.this.updateStatsIfNecessary();
            }
        }
    }

    protected static class DummyTimeCounter
    implements TimeCounter {
        protected DummyTimeCounter() {
        }

        @Override
        public void stop() {
        }
    }

    public static interface TimeCounter {
        public void stop();
    }

    public static interface Category {
    }
}

