/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Pool<T> {
    private final List<T> resources = new ArrayList<T>();
    protected final Map<T, String> inUse = Collections.synchronizedMap(new WeakHashMap());
    private final int maxSize;
    private final int startSize;
    protected int highwater = 0;
    protected String name;
    private static final Logger defaultLog = Logger.getLogger(Pool.class.getName());
    final Logger log;

    protected Pool(int maxSize, int startSize, String name) {
        this(maxSize, startSize, name, defaultLog);
    }

    protected Pool(int maxSize, int startSize, String name, Logger log) {
        this.maxSize = maxSize;
        this.name = name;
        this.startSize = startSize;
        this.log = log;
        assert (maxSize > 0) : "Pool must be of max size greater than 0 . You specified " + maxSize;
        assert (startSize <= maxSize);
    }

    public void initialize() {
        this.fill(this.startSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> members() {
        Object object = this.getLock();
        synchronized (object) {
            return new ArrayList<T>(this.getResources());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T resource = null;
        Object object = this.getLock();
        synchronized (object) {
            resource = this.getOrMake();
        }
        this.checkedOut(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fill(int size) {
        Object object = this.getLock();
        synchronized (object) {
            for (int i = 0; i < size; ++i) {
                T resource = this.callAllocate();
                boolean added = this.putPooled(resource);
                assert (added) : "could not add" + resource;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> inUse() {
        Object object = this.getLock();
        synchronized (object) {
            return new ArrayList<T>(this.inUse.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> all() {
        Object object = this.getLock();
        synchronized (object) {
            List<T> all = this.inUse();
            all.addAll(this.getResources());
            return all;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> clear() {
        Object object = this.getLock();
        synchronized (object) {
            ArrayList<T> all = new ArrayList<T>(this.inUse());
            all.addAll(this.getResources());
            this.getResources().clear();
            return all;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getOrMake() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isEmpty()) {
                return this.callAllocate();
            }
            return this.getPooled();
        }
    }

    protected T callAllocate() {
        return this.allocateResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getSize() == 0;
        }
    }

    public boolean remove(Object pooled) {
        return this.getResources().remove(pooled);
    }

    protected T getPooled() {
        try {
            return this.resources.remove(this.resources.size() - 1);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Collection<T> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(T resource) {
        this.returned(resource);
        Object object = this.getLock();
        synchronized (object) {
            if (this.getSize() >= this.getMaxSize()) {
                this.overflow(resource);
                return false;
            }
            return this.putPooled(resource);
        }
    }

    protected void overflow(T resource) {
        this.log.log(Level.WARNING, "Pool named {0} exceeded max size of {1}. Discarding pooled resource of type {2}", new Object[]{this.getName(), this.getMaxSize(), resource.getClass()});
    }

    protected void checkedOut(T resource) {
        this.inUse.put(resource, "used");
    }

    protected void returned(T resource) {
        this.inUse.remove(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getResources().size();
        }
    }

    protected boolean putPooled(T resource) {
        assert (resource != null);
        boolean added = this.addResource(resource);
        if (!added) {
            this.log.log(Level.WARNING, "could not add {0} already in {1}", new Object[]{resource, this.getResources()});
        }
        return added;
    }

    protected boolean addResource(T resource) {
        this.getResources().add(resource);
        return true;
    }

    protected abstract T allocateResource();

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Pool " + this.getName() + " capacity " + this.getMaxSize() + " size " + this.getSize();
    }

    protected Object getLock() {
        return this;
    }
}

