/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.hds.commons.util.ByteBufferPoolBase;
import com.hds.commons.util.MemoryPool;
import com.hds.commons.util.logging.RISLogger;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class ShareableByteBufferPool
extends ByteBufferPoolBase {
    private static final RISLogger log = RISLogger.getLogger();
    private final AtomicLong sharedAvailable;

    public static ShareableByteBufferPool create(long maxMemorySize, long minMemorySize) {
        return ShareableByteBufferPool.builder(maxMemorySize, minMemorySize).build();
    }

    public static Builder builder(long maxMemorySize, long minMemorySize) {
        return new Builder(maxMemorySize, minMemorySize);
    }

    ShareableByteBufferPool(Builder pc) {
        super(pc);
        this.sharedAvailable = new AtomicLong(this.maxMemorySize);
    }

    public Share createShare(String name, long reserve, long maxMemory, ByteBufferPoolBase.Exhaustion exhaustion, boolean setLimit) {
        return new Share(name, reserve, maxMemory, exhaustion, setLimit);
    }

    public static class Builder
    extends ByteBufferPoolBase.PoolConfigurationBase<Builder> {
        private Builder(long maxMemorySize, long minMemorySize) {
            super(maxMemorySize, minMemorySize);
        }

        @Override
        Builder instance() {
            return this;
        }

        public ShareableByteBufferPool build() {
            return new ShareableByteBufferPool(this);
        }
    }

    public final class Share
    implements MemoryPool<ByteBuffer> {
        private final AtomicLong reservedAvailable;
        private final AtomicLong sharedUsed = new AtomicLong();
        private final String name;
        private final long maxShared;
        private final ByteBufferPoolBase.Exhaustion exhaustion;
        private final boolean setLimit;
        private final Function<ByteBuffer, Void> onReturn = new Function<ByteBuffer, Void>(){

            public Void apply(ByteBuffer input) {
                Share.this.unreserve(input.capacity());
                return null;
            }
        };
        private final ByteBufferPoolBase.AllocationCallbacks allocationCallbacks = new ByteBufferPoolBase.AllocationCallbacks(){

            @Override
            public boolean preAllocation(int capacity) {
                return Share.this.reserve(capacity);
            }

            @Override
            public boolean postAllocation(int capacity, ByteBuffer buffer) {
                return Share.this.handleOverAllocation(capacity, buffer);
            }

            @Override
            public void allocationFailure(int capacity) {
                Share.this.unreserve(capacity);
            }

            @Override
            public void exhausted(int capacity, int retry) {
                if (retry % ShareableByteBufferPool.this.getRetryLogThreshold() == 0 && retry != 0) {
                    Share.this.logExhaustion(capacity, retry);
                }
            }
        };

        private Share(String name, long reserve, long maxMemory, ByteBufferPoolBase.Exhaustion exhaustion, boolean setLimit) {
            long available;
            Preconditions.checkArgument((reserve <= maxMemory ? 1 : 0) != 0);
            do {
                if ((available = ShareableByteBufferPool.this.sharedAvailable.get()) >= reserve) continue;
                throw new IllegalArgumentException("Can not reserve: " + reserve + "B, available: " + available + "B");
            } while (!ShareableByteBufferPool.this.sharedAvailable.compareAndSet(available, available - reserve));
            this.name = name;
            this.reservedAvailable = new AtomicLong(reserve);
            this.maxShared = maxMemory - reserve;
            this.exhaustion = exhaustion == null ? ByteBufferPoolBase.Exhaustion.NONE : exhaustion;
            this.setLimit = setLimit;
        }

        @Override
        public long getMaxPoolSizeInBytes() {
            return ShareableByteBufferPool.this.maxMemorySize;
        }

        @Override
        public long getMinPoolSizeInBytes() {
            return ShareableByteBufferPool.this.minMemorySize;
        }

        @Override
        public long getPoolIdleAgeoutMillis() {
            return ShareableByteBufferPool.this.ageoutTimeMillis;
        }

        @Override
        public ByteBuffer allocateResource(int capacity) {
            return this.allocateResource(capacity, this.exhaustion);
        }

        @Override
        public ByteBuffer tryAllocateResource(int capacity) {
            return this.allocateResource(capacity, ByteBufferPoolBase.Exhaustion.NONE);
        }

        public ByteBuffer allocateResource(int capacity, ByteBufferPoolBase.Exhaustion exhaustion) {
            ByteBuffer resource = ShareableByteBufferPool.this.allocateResource(capacity, this.allocationCallbacks, exhaustion);
            if (this.setLimit && resource != null) {
                resource.limit(capacity);
            }
            return resource;
        }

        @Override
        public void returnResource(ByteBuffer resource) {
            ShareableByteBufferPool.this.returnResource(resource, this.onReturn);
        }

        private boolean handleOverAllocation(int requestedCapacity, ByteBuffer resource) {
            int overAllocation = resource.capacity() - requestedCapacity;
            return overAllocation == 0 || this.reserve(overAllocation);
        }

        private boolean reserve(int capacity) {
            long reserved;
            long available;
            while (!this.reservedAvailable.compareAndSet(available = this.reservedAvailable.get(), available - (reserved = Math.min(available, (long)capacity)))) {
            }
            if (reserved != (long)capacity) {
                long wanted = (long)capacity - reserved;
                do {
                    if ((available = ShareableByteBufferPool.this.sharedAvailable.get()) >= wanted && this.sharedUsed.get() + wanted <= this.maxShared) continue;
                    this.reservedAvailable.getAndAdd(reserved);
                    return false;
                } while (!ShareableByteBufferPool.this.sharedAvailable.compareAndSet(available, available - wanted));
                if (this.sharedUsed.addAndGet(wanted) > this.maxShared) {
                    this.unreserve(capacity);
                    return false;
                }
            }
            return true;
        }

        private void unreserve(int capacity) {
            long shared = this.sharedUsed.get();
            long returned = 0L;
            if (shared > 0L) {
                returned = Math.min(shared, (long)capacity);
                while (!this.sharedUsed.compareAndSet(shared, shared - returned)) {
                    shared = this.sharedUsed.get();
                    returned = Math.min(shared, (long)capacity);
                }
                ShareableByteBufferPool.this.sharedAvailable.getAndAdd(returned);
            }
            if (returned < (long)capacity) {
                this.reservedAvailable.getAndAdd((long)capacity - returned);
            }
        }

        private void logExhaustion(int capacity, int retry) {
            log.log(Level.INFO, "{0} {1}: Can not allocate: {2}, reservedAvailable: {3}, maxShared: {4}, sharedUsed: {5}, sharedAvailable: {6}, retry: {7}", ShareableByteBufferPool.this.name, (Object)this.name, (Object)capacity, (Object)this.reservedAvailable.get(), (Object)this.maxShared, (Object)this.sharedUsed.get(), (Object)ShareableByteBufferPool.this.sharedAvailable.get(), (Object)retry);
        }
    }
}

