/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.HdsCommonsConfig;
import com.hds.commons.util.SynchronousWorkQueue;
import com.hds.commons.util.Thunk;
import com.hds.commons.util.TracingThunk;
import com.hds.commons.util.WorkQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleWorkQueue
extends SynchronousWorkQueue {
    private static final Logger defaultlog = Logger.getLogger(SimpleWorkQueue.class.getName());
    protected final LinkedList<Thunk> queue = new LinkedList();
    final List<Worker> workers;
    final ThreadGroup workerGroup;
    protected int highWorkerCount = 1;
    protected int highLevelMark = 2;
    protected int maxWorkers;
    protected volatile boolean started = false;
    protected int currentWorkers;
    private int workersOnBreak = 0;

    public SimpleWorkQueue(String name, ThreadGroup workerGroup) {
        this(name, 1, workerGroup);
    }

    public SimpleWorkQueue(String name, Logger log, ThreadGroup workerGroup) {
        this(name, 1, log, workerGroup);
    }

    public SimpleWorkQueue(String name, int maxWorkers, ThreadGroup workerGroup) {
        this(name, maxWorkers, defaultlog, workerGroup);
    }

    public SimpleWorkQueue(String name, int maxWorkers, Logger log, ThreadGroup workerGroup) {
        super(name, log);
        assert (maxWorkers > 0) : "Must use at least one worker thread";
        this.maxWorkers = maxWorkers;
        this.workers = new ArrayList<Worker>(maxWorkers);
        this.workerGroup = workerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this;
        synchronized (object) {
            super.start();
            int loops = Math.min(this.queue.size(), this.maxWorkers);
            for (int i = 0; i < loops; ++i) {
                this.addNewWorker();
            }
            this.started = true;
        }
        object = this.queue;
        synchronized (object) {
            this.queue.notifyAll();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected Worker getWorkerThread(int count) {
        Worker worker = this.createWorker(count);
        worker.start();
        return worker;
    }

    protected Worker createWorker(int count) {
        return new Worker(this.getName(), count);
    }

    @Override
    public boolean enqueue(Thunk work) {
        if (this.checkStatus()) {
            return this.actuallyEnqueue(work);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean actuallyEnqueue(Thunk posted) {
        Thunk work = TracingThunk.create(posted);
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            assert (this.getWorkersOnBreak() >= 0) : this.getWorkersOnBreak();
            int size = this.queue.size();
            if (this.getWorkersOnBreak() <= size && this.started) {
                SimpleWorkQueue simpleWorkQueue = this;
                synchronized (simpleWorkQueue) {
                    int needed = size + 1 - this.getWorkersOnBreak();
                    while (needed-- > 0 && this.newWorkerAllowed()) {
                        this.addNewWorker();
                    }
                    if (size > this.highLevelMark && !this.newWorkerAllowed()) {
                        this.highLevelMark = size;
                        this.growingQueue();
                    }
                }
            }
            this.addWork(work);
            assert (!this.started || this.currentWorkers > 0);
            assert (this.queue.size() > 0);
            this.queue.notify();
        }
        return true;
    }

    protected void addWork(Thunk work) {
        this.queue.addLast(work);
    }

    protected void growingQueue() {
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, "queue -{0}- is growing at {1} with maximum number of threads of {2} allocated.", new Object[]{this.getName(), this.highLevelMark, this.maxWorkers});
        }
    }

    protected synchronized int unitializedWorkers() {
        return this.maxWorkers - this.currentWorkers;
    }

    protected synchronized boolean newWorkerAllowed() {
        return this.currentWorkers < this.maxWorkers;
    }

    protected synchronized void addNewWorker() {
        this.workers.add(this.getWorkerThread(this.currentWorkers));
        ++this.currentWorkers;
        if (this.currentWorkers > this.highWorkerCount) {
            this.highWorkerCount = this.currentWorkers;
            this.log.log(Level.WARNING, "new high water mark for work queue {0} is {1}", new Object[]{this.getName(), this.highWorkerCount});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            super.shutdown();
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            super.close();
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Thunk> join(long timeoutMs) throws InterruptedException {
        ArrayList<Worker> myCopy;
        Thread joiner = Thread.currentThread();
        Worker workerJoiner = joiner instanceof Worker ? (Worker)joiner : null;
        LinkedList<Thunk> linkedList = this;
        synchronized (linkedList) {
            if (!this.started) {
                return Collections.emptyList();
            }
            assert (!this.isOpen()) : " cannot join open queue " + this;
            myCopy = new ArrayList<Worker>(this.workers);
        }
        for (Worker t : myCopy) {
            if (!t.isAlive() || t == workerJoiner) continue;
            t.join(timeoutMs);
        }
        this.log.log(Level.INFO, "Joined.");
        linkedList = this.queue;
        synchronized (linkedList) {
            if (!this.blocking && !this.queue.isEmpty()) {
                this.log.log(Level.WARNING, "After a close abandoned {0} work items. Queues must have shutdown. ", this.queue.size());
            }
            return this.queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Thunk grabWork() {
        while (true) {
            if (!this.isRunning) {
                return null;
            }
            LinkedList<Thunk> linkedList = this.queue;
            synchronized (linkedList) {
                if (!this.queue.isEmpty()) break;
                if (!this.blocking) {
                    this.log.log(Level.FINE, "All available work processed {0}", this.name);
                    return null;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e1) {
                    this.log.log(Level.FINE, "Interrupted while waiting for work to process {0}", this.name);
                }
                this.log.log(Level.FINEST, "Moving on. {0}", this.name);
            }
        }
        {
            this.decrementWorkersOnBreak();
            Thunk thunk = this.queue.removeFirst();
            assert (thunk != null);
            return thunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getWorkersOnBreak() {
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            return this.workersOnBreak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementWorkersOnBreak() {
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            ++this.workersOnBreak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementWorkersOnBreak() {
        LinkedList<Thunk> linkedList = this.queue;
        synchronized (linkedList) {
            --this.workersOnBreak;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public class Worker
    extends Thread {
        public final int number;
        boolean interrupted;

        public WorkQueue getQueue() {
            return SimpleWorkQueue.this;
        }

        public Worker(String name, int number) {
            super(SimpleWorkQueue.this.workerGroup, name + " thread " + number);
            this.number = number;
            SimpleWorkQueue.this.incrementWorkersOnBreak();
        }

        @Override
        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            Worker worker = this;
            synchronized (worker) {
                this.interrupted = true;
            }
            super.interrupt();
        }

        @Override
        public void run() {
            while (SimpleWorkQueue.this.isRunning) {
                Thunk thunk = SimpleWorkQueue.this.grabWork();
                if (thunk == null) {
                    return;
                }
                try {
                    thunk.doit();
                }
                catch (ThreadDeath e) {
                    this.handle(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handle(e);
                    throw e;
                }
                catch (Error e) {
                    this.handle(e);
                    throw e;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        if (super.isInterrupted()) {
                            SimpleWorkQueue.this.log.log(Level.WARNING, "Interrupted due to JVM shutdown: {0}", SimpleWorkQueue.this.name);
                            if (!SimpleWorkQueue.this.isRunning) continue;
                            SimpleWorkQueue.this.shutdown();
                            continue;
                        }
                        this.handle(e);
                        throw new RuntimeException("Interrupted unexpectedly", e);
                    }
                    this.handle(e);
                    throw new RuntimeException(e);
                }
                finally {
                    SimpleWorkQueue.this.incrementWorkersOnBreak();
                }
            }
            SimpleWorkQueue.this.log.log(Level.FINE, "Done {0}", SimpleWorkQueue.this.name);
        }

        private void handle(Throwable e) {
            try {
                if (HdsCommonsConfig.isBacktraceEnabled()) {
                    SimpleWorkQueue.this.log.log(Level.SEVERE, "unhandled exception. Shutting down. ", e);
                } else {
                    SimpleWorkQueue.this.log.log(Level.SEVERE, "unhandled exception. Shutting down. To see where this work was enqueued, run with -Dcom.hds.commons.enableBacktrace=true for more detail.", e);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            SimpleWorkQueue.this.shutdown();
        }
    }
}

