/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.hds.commons.exception.InvalidEnumException;
import com.hds.commons.util.EnumHelper;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public enum StorageUnit {
    B(0),
    KB(1){

        @Override
        public double toKB(double size) {
            return size;
        }
    }
    ,
    MB(2){

        @Override
        public double toMB(double size) {
            return size;
        }
    }
    ,
    GB(3){

        @Override
        public double toGB(double size) {
            return size;
        }
    }
    ,
    TB(4){

        @Override
        public double toTB(double size) {
            return size;
        }
    }
    ,
    PB(5){

        @Override
        public double toPB(double size) {
            return size;
        }
    };

    private static final String formatString = "0.#";
    static final int KILO = 1024;
    private static final double KILO_LOG;
    private final double toBytes;

    private StorageUnit(int power) {
        this.toBytes = Math.pow(1024.0, power);
    }

    public static StorageUnit checkedValueOf(String name) throws InvalidEnumException {
        return EnumHelper.checkedValueOf(StorageUnit.class, name.toUpperCase());
    }

    public static double toPB(String sizeString) throws InvalidEnumException {
        return B.toPB(StorageUnit.toB(sizeString));
    }

    public static double toTB(String sizeString) throws InvalidEnumException {
        return B.toTB(StorageUnit.toB(sizeString));
    }

    public static double toGB(String sizeString) throws InvalidEnumException {
        return B.toGB(StorageUnit.toB(sizeString));
    }

    public static double toMB(String sizeString) throws InvalidEnumException {
        return B.toMB(StorageUnit.toB(sizeString));
    }

    public static double toKB(String sizeString) throws InvalidEnumException {
        return B.toKB(StorageUnit.toB(sizeString));
    }

    public static double toUnit(String sizeString, StorageUnit unit) throws InvalidEnumException {
        return B.toUnit(StorageUnit.toB(sizeString), unit);
    }

    public static String humanReadable(double size) {
        return StorageUnit.humanReadable(size, B);
    }

    public static String humanReadable(double size, Locale locale) {
        return StorageUnit.humanReadable(size, B, locale);
    }

    public static String humanReadable(double size, StorageUnit unit) {
        return StorageUnit.humanReadable(size, unit, null);
    }

    public static String humanReadable(double size, StorageUnit unit, Locale locale) {
        double absSize = Math.abs(size);
        if (absSize >= 0.9 && absSize < 1024.0) {
            return unit.toNiceString(size, locale);
        }
        double absSizeB = unit.toB(absSize);
        int i = 0;
        if (absSizeB > 1024.0) {
            i = (int)(Math.log(absSizeB) / KILO_LOG);
        }
        StorageUnit[] units = StorageUnit.values();
        StorageUnit hrUnit = units[Math.min(i, units.length - 1)];
        return hrUnit.toNiceString(unit.toUnit(size, hrUnit), locale);
    }

    public static long toB(String sizeString) throws InvalidEnumException {
        return StorageUnit.toB(sizeString, GB);
    }

    public static long toB(String sizeString, StorageUnit unit) throws InvalidEnumException {
        ParsePosition ppos = new ParsePosition(0);
        double size = NumberFormat.getInstance().parse(sizeString, ppos).doubleValue();
        if (ppos.getIndex() == 0) {
            throw new NumberFormatException("Unparseable number: \"" + sizeString + "\" at index " + ppos.getErrorIndex());
        }
        if (ppos.getIndex() != sizeString.length()) {
            unit = StorageUnit.checkedValueOf(sizeString.substring(ppos.getIndex()).trim());
        }
        return unit.toB(size);
    }

    public String toNiceString(double size) {
        return this.toNiceString(size, null);
    }

    public String toNiceString(double size, Locale locale) {
        if (locale == null) {
            return new DecimalFormat(formatString).format(size) + ' ' + this.name();
        }
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(locale);
        formatter.applyPattern(formatString);
        return formatter.format(size) + ' ' + this.getText(this.name(), locale);
    }

    public double toUnit(double size, StorageUnit unit) {
        return size * this.toBytes / unit.toBytes;
    }

    public double toPB(double size) {
        return this.toTB(size) / 1024.0;
    }

    public double toTB(double size) {
        return this.toGB(size) / 1024.0;
    }

    public double toGB(double size) {
        return this.toMB(size) / 1024.0;
    }

    public double toMB(double size) {
        return this.toKB(size) / 1024.0;
    }

    public double toKB(double size) {
        return this.toB(size) / 1024L;
    }

    public long toB(double size) {
        return (long)(size * this.toBytes);
    }

    @Deprecated
    public long toBytes(double size) {
        return this.toB(size);
    }

    public double fromBytes(long bytes) {
        return (double)bytes / this.toBytes;
    }

    public String getText(String key, Locale locale) {
        try {
            return ResourceBundle.getBundle("com.hds.commons.util.LocalStrings", locale).getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static Storage storageFromString(String str) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(str, " ");
        try {
            Number units = NumberFormat.getNumberInstance().parse(tok.nextToken());
            String unitStr = tok.nextToken();
            double val = units.doubleValue();
            if (val < 0.0) {
                throw new IllegalArgumentException("Illegal value: " + units);
            }
            try {
                StorageUnit storageUnit = StorageUnit.valueOf(unitStr);
                return new Storage(val, storageUnit);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(unitStr + " is not a valid storage unit.");
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse input string: " + str, e);
        }
    }

    public static Storage storageFromBytes(long bytes, StorageUnit unit) {
        return new Storage(unit.fromBytes(bytes), unit);
    }

    static {
        KILO_LOG = Math.log(1024.0);
    }

    public static class Storage {
        private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,##0.00");
        public final double unitCnt;
        public final StorageUnit unit;

        public Storage(double units, StorageUnit storageUnit) {
            this.unitCnt = units;
            this.unit = storageUnit;
        }

        public Storage(double units, String unitStr) {
            this(units, StorageUnit.valueOf(unitStr));
        }

        public long getBytes() {
            return this.unit.toB(this.unitCnt);
        }

        public String unitCntToString() {
            return DECIMAL_FORMAT.format(this.unitCnt);
        }

        public String toString() {
            return this.unitCntToString() + " " + this.unit.toString();
        }
    }
}

