/*
 * Decompiled with CFR 0.152.
 */
package com.hds.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.hds.commons.strings.Joiners;
import com.hds.commons.strings.Splitters;
import com.hds.commons.util.Base64Utils;
import com.hds.commons.util.XMLUtils;
import com.hds.commons.util.logging.RISLogger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;

public class StringUtils {
    private static final RISLogger log = RISLogger.getLogger();
    public static final String line_sep = System.getProperty("line.separator");
    public static final Long KB = 1024L;
    public static final Long MB = KB * 1024L;
    public static final Long GB = MB * 1024L;
    public static final Long TB = GB * 1024L;
    public static final Long PB = TB * 1024L;
    public static final String DEFAULT_ENC = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String DEFAULT_CHARSET_STRING = ";charset=UTF-8";
    public static final Splitter CSV_SPLITTER = Splitters.csv();
    public static final Splitter.MapSplitter COMMA_EQUALS_MAP_SPLITTER = CSV_SPLITTER.withKeyValueSeparator('=');
    public static final Joiner.MapJoiner COMMA_EQUALS_MAP_JOINER = Joiners.comma().withKeyValueSeparator("=");
    public static final Joiner CSV_JOINER = Joiners.comma().skipNulls();
    public static final Joiner SEMICOLON_JOINER = Joiner.on((String)"; ").skipNulls();
    public static final int MAX_COLLECTION_TOSTRING_LENGTH = 10000;
    public static final String SLASH = "/";
    public static final String EMPTY = "";
    public static final String DOUBLEQUOTE = "\"";

    public static String convertNewlineToHtml(String input) {
        return input.replaceAll(" ", "<BR>");
    }

    public static String getDefaultEncoding() {
        return DEFAULT_ENC;
    }

    public static String xmlEscape(String string) {
        char[] chars;
        string = XMLUtils.escape(string);
        StringBuilder buffer = new StringBuilder(string.length() * 2);
        block5: for (char ch : chars = string.toCharArray()) {
            switch (ch) {
                case '\"': {
                    buffer.append("&quot;");
                    continue block5;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block5;
                }
                case '\'': {
                    buffer.append("&apos;");
                    continue block5;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String indent(String input, int level) {
        String sep = System.getProperty("line.separator");
        String singleIndent = "    ";
        String indent = EMPTY;
        String output = (indent = indent + Strings.repeat((String)singleIndent, (int)level)) + input.replaceAll(sep, sep + indent);
        if (output.endsWith(indent)) {
            output = output.substring(0, output.length() - indent.length());
        }
        return output;
    }

    public static boolean isNullOrBlank(String string) {
        return org.apache.commons.lang.StringUtils.isBlank((String)string);
    }

    public static List<String> filterOutNullEmptyBlank(List<String> strings) {
        return strings == null || strings.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)Collections2.filter(strings, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !StringUtils.isNullOrBlank(input);
            }
        }));
    }

    public static boolean containsDuplicates(List<String> strings) {
        List<String> filteredList = StringUtils.filterOutNullEmptyBlank(strings);
        return Sets.newHashSet(filteredList).size() != filteredList.size();
    }

    public static String toCSV(Collection<?> col) {
        return StringUtils.toCSV(col, ", ", null, null);
    }

    public static String toLimitedString(Collection<?> col) {
        return StringUtils.toCSV(col, ", ", "[", "]", true);
    }

    public static String toLimitedString(Map<?, ?> map) {
        return StringUtils.toCSV(map.entrySet(), ", ", "{", "}", true);
    }

    public static String toCSV(Collection<?> col, String separator) {
        return StringUtils.toCSV(col, separator, null, null);
    }

    public static String toCSV(Collection<?> col, String separator, String prefix, String suffix) {
        return StringUtils.toCSV(col, separator, prefix, suffix, false);
    }

    private static String toCSV(Collection<?> col, String separator, String prefix, String suffix, boolean useLimit) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        int suffixLength = suffix == null ? 0 : suffix.length();
        int appendLimit = 10000 - (suffixLength + 3);
        if (col != null) {
            Iterator<?> it = col.iterator();
            while (it.hasNext()) {
                String item = EMPTY + it.next();
                if (!useLimit || sb.length() + item.length() < appendLimit) {
                    sb.append(item);
                    if (!it.hasNext()) continue;
                    sb.append(separator);
                    continue;
                }
                sb.append("...");
                break;
            }
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static List<String> getListFromCSV(String csvList) {
        return StringUtils.getListFromCSV(csvList, " \t\n\r\f");
    }

    public static List<String> getListFromCSV(String csvList, String delimiters) {
        ArrayList<String> list = null;
        if (csvList != null) {
            list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(csvList, delimiters);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    public static List<Integer> getIntegerListFromCSV(String csvList) throws NumberFormatException {
        return StringUtils.getIntegerListFromCSV(csvList, " ,:;");
    }

    public static List<Integer> getIntegerListFromCSV(String csvList, String delimiters) throws NumberFormatException {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        List<String> list = StringUtils.getListFromCSV(csvList, delimiters);
        for (String s : list) {
            retList.add(Integer.valueOf(s));
        }
        return retList;
    }

    public static List<Long> getLongListFromCSV(String csvList) throws NumberFormatException {
        return StringUtils.getLongListFromCSV(csvList, " ,:;");
    }

    public static List<Long> getLongListFromCSV(String csvList, String delimiters) throws NumberFormatException {
        ArrayList<Long> retList = new ArrayList<Long>();
        List<String> list = StringUtils.getListFromCSV(csvList, delimiters);
        for (String s : list) {
            retList.add(Long.valueOf(s));
        }
        return retList;
    }

    public static String formatUrl(String template, String ... args) throws IllegalArgumentException {
        return StringUtils.formatString(template, args);
    }

    public static String formatString(String template, Object[] args) throws IllegalArgumentException {
        String retVal = null;
        if (template == null) {
            throw new IllegalArgumentException("Template can not be null.");
        }
        try {
            retVal = MessageFormat.format(template, args);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder(49);
            msg.append("Args don't match the template.  Template= ");
            msg.append(line_sep);
            msg.append(template);
            msg.append(line_sep).append(line_sep);
            msg.append("args = ");
            if (args == null) {
                msg.append("null args");
            } else if (args.length == 0) {
                msg.append("no args");
            } else {
                for (int i = 0; i < args.length; ++i) {
                    msg.append("arg ").append(i).append(" = ").append(EMPTY + args[i]);
                }
            }
            IllegalArgumentException e2 = new IllegalArgumentException(msg.toString());
            e2.initCause(e);
            throw e2;
        }
        return retVal;
    }

    public static String encodeFilename(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        for (char currChar : path.toCharArray()) {
            if (currChar == '/') {
                if (fragment.length() > 0) {
                    String encodedFrag = StringUtils.encodeUrl(fragment.toString());
                    output.append(encodedFrag);
                    fragment = new StringBuilder();
                }
                output.append('/');
                continue;
            }
            fragment.append(currChar);
        }
        if (fragment.length() > 0) {
            String encodedFrag = StringUtils.encodeUrl(fragment.toString());
            output.append(encodedFrag);
        }
        return output.toString();
    }

    public static String decodeFilename(String path) throws UnsupportedEncodingException {
        if (path == null) {
            return null;
        }
        return URLDecoder.decode(path, StringUtils.getDefaultEncoding());
    }

    public static String urlDecode(String term) {
        try {
            return StringUtils.decodeFilename(term);
        }
        catch (UnsupportedEncodingException e) {
            return term;
        }
    }

    public static String encodeUrl(String string) throws RuntimeException {
        try {
            return string == null ? null : URLEncoder.encode(string, StringUtils.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding doesn't exist: " + StringUtils.getDefaultEncoding(), e);
        }
    }

    public static String decodeUrl(String string) throws RuntimeException {
        try {
            return string == null ? null : URLDecoder.decode(string, StringUtils.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding doesn't exist: " + StringUtils.getDefaultEncoding(), e);
        }
    }

    public static List<String> parseDirList(List<String> dirList) {
        return StringUtils.parseDirList(dirList, false);
    }

    public static List<String> parseDirList(List<String> dirList, boolean base64Encoded) {
        if (dirList == null) {
            return null;
        }
        ArrayList<String> processedList = new ArrayList<String>();
        for (String dir : dirList) {
            if (base64Encoded) {
                dir = Base64Utils.decodeForUI(dir);
            }
            processedList.add(dir.length() > 0 && dir.charAt(0) == '/' ? dir.substring(1).trim() : dir.trim());
        }
        return processedList;
    }

    public static List<String> diffDirLists(List<String> a, List<String> b) {
        if (a == null || b == null) {
            return StringUtils.parseDirList(a);
        }
        List<String> resultList = StringUtils.parseDirList(a);
        resultList.removeAll(StringUtils.parseDirList(b));
        return resultList;
    }

    public static String getDefaultEncodedString(byte[] value) throws IllegalArgumentException {
        String retVal = null;
        if (value != null) {
            try {
                retVal = new String(value, StringUtils.getDefaultEncoding());
            }
            catch (UnsupportedEncodingException e) {
                String errMsg = "Unable to create a String using the default encoding: " + StringUtils.getDefaultEncoding() + " for value:" + Arrays.toString(value) + " Error Msg: " + e.getMessage();
                log.log(Level.SEVERE, errMsg);
                throw new IllegalArgumentException(errMsg);
            }
        }
        return retVal;
    }

    public static byte[] getDefaultEncodedBytes(String value) throws IllegalArgumentException {
        byte[] retVal = null;
        if (value != null) {
            try {
                retVal = value.getBytes(StringUtils.getDefaultEncoding());
            }
            catch (UnsupportedEncodingException e) {
                String errMsg = "Unable to get encoded bytes for value: " + value + " Error Msg: " + e.getMessage();
                log.log(Level.SEVERE, errMsg);
                throw new IllegalArgumentException(errMsg);
            }
        }
        return retVal;
    }

    public static Set<String> toCaseInsensitiveSet(Collection<String> collection) {
        TreeSet<String> ret = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ret.addAll(collection);
        return ret;
    }

    public static List<UUID> csvToListUUID(String csvOfUUIDs) {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        if (csvOfUUIDs != null) {
            for (String uuid : Arrays.asList(csvOfUUIDs.trim().split(","))) {
                if (uuid.trim().equals(EMPTY)) continue;
                uuidList.add(UUID.fromString(uuid.trim()));
            }
        }
        return uuidList;
    }

    public static String uiFilterParse(String filterString) {
        String filter = StringUtils.uiStringParse(filterString);
        return filter == null ? null : filter.toLowerCase();
    }

    public static String uiStringParse(String uiString) {
        return uiString == null || EMPTY.equals(uiString.trim()) ? null : uiString;
    }

    public static Collection<String> filterStringCollection(Collection<String> directories, final String filter) {
        return Strings.isNullOrEmpty((String)filter) ? directories : Collections2.filter(directories, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.toLowerCase().startsWith(filter.toLowerCase());
            }
        });
    }

    public static Collection<UUID> stringsToUUIDs(Collection<String> strings) {
        return Collections2.transform(strings, (Function)new Function<String, UUID>(){

            public UUID apply(String input) {
                return UUID.fromString(input);
            }
        });
    }

    public static List<UUID> stringsToUUIDs(List<String> strings) {
        return Lists.transform(strings, (Function)new Function<String, UUID>(){

            public UUID apply(String input) {
                return UUID.fromString(input);
            }
        });
    }

    public static List<UUID> stringsToUUIDs(String csv) {
        return StringUtils.stringsToUUIDs(Lists.newArrayList((Iterable)CSV_SPLITTER.split((CharSequence)csv)));
    }

    public static String removeTrailingSlash(String str) {
        if (str != null && str.endsWith(SLASH)) {
            return str.substring(0, str.length() - SLASH.length());
        }
        return str;
    }

    public static int getUTF8Length(CharSequence sequence) {
        if (sequence == null || sequence.length() == 0) {
            return 0;
        }
        int utf8Length = 0;
        int len = sequence.length();
        for (int index = 0; index < len; ++index) {
            char ch = sequence.charAt(index);
            if (ch <= '\u007f') {
                ++utf8Length;
                continue;
            }
            if (ch <= '\u07ff') {
                utf8Length += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                utf8Length += 4;
                ++index;
                continue;
            }
            utf8Length += 3;
        }
        return utf8Length;
    }

    public static String getDisplayString(long bytes) {
        return StringUtils.getDisplayValue(bytes).getDisplayValue();
    }

    public static String getDisplayString(long bytes, String formatString) {
        return StringUtils.getDisplayValue(bytes).getDisplayValue(formatString);
    }

    private static DisplaySize getDisplayValue(long bytes) {
        return new DisplaySize(bytes);
    }

    public static String createRegexPattern(String simplePattern) {
        StringBuilder result = new StringBuilder();
        result.append('^');
        for (char c : simplePattern.toCharArray()) {
            if (c == '[' || c == ']' || c == '|' || c == '(' || c == ')' || c == '{' || c == '}' || c == '?' || c == '+' || c == '$' || c == '^' || c == '.' || c == '\\') {
                result.append('\\');
                result.append(c);
                continue;
            }
            if (c == '*') {
                result.append(".*?");
                continue;
            }
            result.append(c);
        }
        result.append('$');
        return result.toString();
    }

    public static <T> Map.Entry<String, T> longestPrefixMatch(String key, NavigableMap<String, T> map) {
        String currentKey = key;
        Map.Entry<String, T> entry = map.floorEntry(currentKey);
        while (entry != null && !key.startsWith(entry.getKey())) {
            currentKey = Strings.commonPrefix((CharSequence)currentKey, (CharSequence)entry.getKey());
            entry = map.floorEntry(currentKey);
        }
        return entry;
    }

    public static String blankToString(String input, String returnIfBlank) {
        return org.apache.commons.lang.StringUtils.isBlank((String)input) ? returnIfBlank : input;
    }

    public static Ordering<CharSequence> codePointOrder() {
        return CodePointOrder.INSTANCE;
    }

    public static String leastStringGreaterThanAllPrefixed(CharSequence prefix) {
        Preconditions.checkNotNull((Object)prefix);
        int endIndex = StringUtils.maxCodePointTrailingIndex(prefix);
        if (endIndex == 0) {
            return null;
        }
        int lastCodepoint = Character.codePointBefore(prefix, endIndex);
        StringBuilder builder = new StringBuilder(endIndex + 1);
        builder.append(prefix, 0, endIndex - Character.charCount(lastCodepoint));
        int nextCodePoint = StringUtils.incrementCodePoint(lastCodepoint);
        if (Character.isBmpCodePoint(nextCodePoint)) {
            builder.append((char)nextCodePoint);
        } else {
            builder.append(Character.highSurrogate(nextCodePoint)).append(Character.lowSurrogate(nextCodePoint));
        }
        return builder.toString();
    }

    public static String nextGreatestString(CharSequence string) {
        return new StringBuilder(string.length() + 1).append(string).appendCodePoint(0).toString();
    }

    private static int incrementCodePoint(int codePoint) {
        Preconditions.checkArgument((Character.isValidCodePoint(codePoint) && codePoint < 0x10FFFF ? 1 : 0) != 0, (Object)"Not a valid code point");
        if (Character.isBmpCodePoint(codePoint)) {
            Preconditions.checkArgument((!Character.isSurrogate((char)codePoint) ? 1 : 0) != 0, (Object)"Character is a surrogate");
        }
        if (codePoint == 55295) {
            return 57344;
        }
        return codePoint + 1;
    }

    private static int maxCodePointTrailingIndex(CharSequence string) {
        int afterLast;
        for (afterLast = string.length(); afterLast > 0 && Character.codePointBefore(string, afterLast) == 0x10FFFF; afterLast -= Character.charCount(0x10FFFF)) {
        }
        return afterLast;
    }

    private StringUtils() {
    }

    private static class CodePointOrder
    extends Ordering<CharSequence>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final CodePointOrder INSTANCE = new CodePointOrder();

        private CodePointOrder() {
            Preconditions.checkState((INSTANCE == null ? 1 : 0) != 0);
        }

        public int compare(CharSequence left, CharSequence right) {
            int lim = Math.min(left.length(), right.length());
            for (int i = 0; i < lim; ++i) {
                char cright;
                char cleft = left.charAt(i);
                if (cleft == (cright = right.charAt(i))) continue;
                int leftCodePoint = this.toCodePoint(left, cleft, i);
                int rightCodePoint = this.toCodePoint(right, cright, i);
                return leftCodePoint - rightCodePoint;
            }
            return left.length() - right.length();
        }

        private int toCodePoint(CharSequence seq, char first, int index) {
            char second;
            if (Character.isHighSurrogate(first) && ++index < seq.length() && Character.isLowSurrogate(second = seq.charAt(index))) {
                return Character.toCodePoint(first, second);
            }
            return first;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "StringUtils.codePointOrder()";
        }
    }

    private static class DisplaySize {
        private final double value;
        private final Unit unit;
        private static final String DEFAULT_FORMAT = "%01.2f %s";
        private static final String BYTES_FORMAT = "%01.0f %s";

        public DisplaySize(long bytes) {
            double value = bytes;
            double absValue = Math.abs(value);
            if (absValue > (double)PB.longValue()) {
                this.value = value / (double)PB.longValue();
                this.unit = Unit.PB;
            } else if (absValue > (double)TB.longValue()) {
                this.value = value / (double)TB.longValue();
                this.unit = Unit.TB;
            } else if (absValue > (double)GB.longValue()) {
                this.value = value / (double)GB.longValue();
                this.unit = Unit.GB;
            } else if (absValue > (double)MB.longValue()) {
                this.value = value / (double)MB.longValue();
                this.unit = Unit.MB;
            } else if (absValue > (double)KB.longValue()) {
                this.value = value / (double)KB.longValue();
                this.unit = Unit.KB;
            } else {
                this.value = value;
                this.unit = Unit.B;
            }
        }

        public String getDisplayValue() {
            if (this.unit != Unit.B) {
                return this.getDisplayValue(DEFAULT_FORMAT);
            }
            return this.getDisplayValue(BYTES_FORMAT);
        }

        public String getDisplayValue(String formatString) {
            return String.format(formatString, this.value, this.unit.toString());
        }

        private static enum Unit {
            PB,
            TB,
            GB,
            MB,
            KB,
            B;

        }
    }
}

